/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.logging.slf4j;

import net.sf.hajdbc.logging.AbstractLogger;
import net.sf.hajdbc.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLogger
extends AbstractLogger {
    private final Logger logger;

    public SLF4JLogger(Class<?> targetClass) {
        this.logger = LoggerFactory.getLogger(targetClass);
    }

    @Override
    public void log(Level level, Throwable e, String pattern, Object ... args) {
        switch (level) {
            case ERROR: {
                if (!this.logger.isErrorEnabled()) break;
                String message = SLF4JLogger.format(pattern, args);
                if (e != null) {
                    this.logger.error(message, e);
                    break;
                }
                this.logger.error(message);
                break;
            }
            case WARN: {
                if (!this.logger.isWarnEnabled()) break;
                String message = SLF4JLogger.format(pattern, args);
                if (e != null) {
                    this.logger.warn(message, e);
                    break;
                }
                this.logger.warn(message);
                break;
            }
            case INFO: {
                if (!this.logger.isInfoEnabled()) break;
                String message = SLF4JLogger.format(pattern, args);
                if (e != null) {
                    this.logger.info(message, e);
                    break;
                }
                this.logger.info(message);
                break;
            }
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                String message = SLF4JLogger.format(pattern, args);
                if (e != null) {
                    this.logger.debug(message, e);
                    break;
                }
                this.logger.debug(message);
                break;
            }
            case TRACE: {
                if (!this.logger.isTraceEnabled()) break;
                String message = SLF4JLogger.format(pattern, args);
                if (e != null) {
                    this.logger.trace(message, e);
                    break;
                }
                this.logger.trace(message);
            }
        }
    }
}

