/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.management;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import net.sf.hajdbc.management.Description;
import net.sf.hajdbc.management.MBean;
import net.sf.hajdbc.management.ManagedAttribute;
import net.sf.hajdbc.management.ManagedOperation;

public class AnnotatedMBean
implements DynamicMBean {
    private final MBeanInfo info;
    private final Object bean;
    private final Map<String, Method> accessorMap = new HashMap<String, Method>();
    private final Map<String, Method> mutatorMap = new HashMap<String, Method>();

    public AnnotatedMBean(Object bean) {
        Class<?> beanClass = bean.getClass();
        MBean mbean = beanClass.getAnnotation(MBean.class);
        if (mbean == null) {
            throw new IllegalArgumentException(String.format("%s is not an @MBean", beanClass));
        }
        this.bean = bean;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            ArrayList<MBeanAttributeInfo> attributeList = new ArrayList<MBeanAttributeInfo>(properties.length);
            for (PropertyDescriptor descriptor : properties) {
                Description description;
                ManagedAttribute managedMutator;
                Method accessor = descriptor.getReadMethod();
                ManagedAttribute managedAccessor = accessor != null ? accessor.getAnnotation(ManagedAttribute.class) : null;
                Method mutator = descriptor.getWriteMethod();
                ManagedAttribute managedAttribute = managedMutator = mutator != null ? mutator.getAnnotation(ManagedAttribute.class) : null;
                if (managedAccessor == null && managedMutator == null) continue;
                String name = descriptor.getName();
                Description description2 = description = accessor != null ? accessor.getAnnotation(Description.class) : null;
                if (description == null && mutator != null) {
                    description = mutator.getAnnotation(Description.class);
                }
                attributeList.add(new MBeanAttributeInfo(name, description != null ? description.value() : null, managedAccessor != null ? accessor : null, managedMutator != null ? mutator : null));
                if (managedAccessor != null) {
                    this.accessorMap.put(name, accessor);
                }
                if (managedMutator == null) continue;
                this.mutatorMap.put(name, mutator);
            }
            MethodDescriptor[] methods = beanInfo.getMethodDescriptors();
            ArrayList<MBeanOperationInfo> operationList = new ArrayList<MBeanOperationInfo>(methods.length);
            for (MethodDescriptor descriptor : beanInfo.getMethodDescriptors()) {
                Method method = descriptor.getMethod();
                ManagedOperation managedMethod = method.getAnnotation(ManagedOperation.class);
                if (managedMethod == null) continue;
                Description description = method.getAnnotation(Description.class);
                operationList.add(new MBeanOperationInfo(description != null ? description.value() : null, method));
            }
            Description description = beanClass.getAnnotation(Description.class);
            this.info = new MBeanInfo(beanClass.getName(), description != null ? description.value() : null, attributeList.toArray(new MBeanAttributeInfo[attributeList.size()]), null, operationList.toArray(new MBeanOperationInfo[operationList.size()]), null);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        catch (javax.management.IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method method = this.accessorMap.get(name);
        if (method == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            return method.invoke(this.bean, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalArgumentException e) {
            throw new MBeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList list = new AttributeList(names.length);
        for (String name : names) {
            try {
                list.add(new Attribute(name, this.getAttribute(name)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    @Override
    public Object invoke(String method, Object[] args, String[] types) throws MBeanException, ReflectionException {
        Class[] classes = new Class[types.length];
        try {
            for (int i = 0; i < types.length; ++i) {
                classes[i] = this.bean.getClass().getClassLoader().loadClass(types[i]);
            }
            return this.bean.getClass().getMethod(method, classes).invoke(this.bean, args);
        }
        catch (ClassNotFoundException e) {
            throw new MBeanException(e);
        }
        catch (IllegalArgumentException e) {
            throw new MBeanException(e);
        }
        catch (SecurityException e) {
            throw new MBeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method method = this.mutatorMap.get(attribute.getName());
        if (method == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        try {
            this.mutatorMap.get(attribute.getName()).invoke(this.bean, attribute.getValue());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAttributeValueException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList(attributes.size());
        for (Object attribute : attributes) {
            try {
                this.setAttribute((Attribute)attribute);
                list.add(attribute);
            }
            catch (Exception e) {}
        }
        return list;
    }
}

