/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.management;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.management.AnnotatedMBean;
import net.sf.hajdbc.management.MBeanRegistrar;

public class DefaultMBeanRegistrar<Z, D extends Database<Z>>
implements MBeanRegistrar<Z, D> {
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String CLUSTER_ATTRIBUTE = "cluster";
    private static final String DATABASE_ATTRIBUTE = "database";
    private static final String CLUSTER_TYPE = "DatabaseCluster";
    private static final String DATABASE_TYPE = "Database";
    private static final Logger logger = LoggerFactory.getLogger(DefaultMBeanRegistrar.class);
    private final MBeanServer server;
    private String domain = DatabaseCluster.class.getPackage().getName();

    public DefaultMBeanRegistrar() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    public DefaultMBeanRegistrar(MBeanServer server) {
        this.server = server;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public void register(DatabaseCluster<Z, D> cluster) throws JMException {
        this.register((Object)cluster, this.createAttributes(cluster));
    }

    @Override
    public void register(DatabaseCluster<Z, D> cluster, D database) throws JMException {
        this.register(database, this.createAttributes(cluster, database));
    }

    private void register(Object object, Hashtable<String, String> attributes) throws JMException {
        ObjectName name = this.createObjectName(attributes);
        this.server.registerMBean(new AnnotatedMBean(object), name);
    }

    @Override
    public void unregister(DatabaseCluster<Z, D> cluster) {
        this.unregister(this.createAttributes(cluster));
    }

    @Override
    public void unregister(DatabaseCluster<Z, D> cluster, D database) {
        this.unregister(this.createAttributes(cluster, database));
    }

    @Override
    private void unregister(Hashtable<String, String> attributes) {
        try {
            ObjectName name = this.createObjectName(attributes);
            if (this.server.isRegistered(name)) {
                this.server.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARN, e);
        }
    }

    private Hashtable<String, String> createAttributes(DatabaseCluster<Z, D> cluster) {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put(TYPE_ATTRIBUTE, CLUSTER_TYPE);
        attributes.put(CLUSTER_ATTRIBUTE, cluster.getId());
        return attributes;
    }

    private Hashtable<String, String> createAttributes(DatabaseCluster<Z, D> cluster, D database) {
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        attributes.put(TYPE_ATTRIBUTE, DATABASE_TYPE);
        attributes.put(CLUSTER_ATTRIBUTE, cluster.getId());
        attributes.put(DATABASE_ATTRIBUTE, database.getId());
        return attributes;
    }

    private ObjectName createObjectName(Hashtable<String, String> attributes) throws MalformedObjectNameException {
        return ObjectName.getInstance(this.domain, attributes);
    }
}

