/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.pool.generic;

import java.util.NoSuchElementException;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.pool.Pool;
import net.sf.hajdbc.pool.PoolFactory;
import net.sf.hajdbc.pool.PoolProvider;
import net.sf.hajdbc.pool.generic.GenericObjectPoolConfiguration;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class GenericObjectPoolFactory
implements PoolFactory {
    static final Logger logger = LoggerFactory.getLogger(GenericObjectPoolFactory.class);
    private final GenericObjectPoolConfiguration config;

    public GenericObjectPoolFactory(GenericObjectPoolConfiguration config) {
        this.config = config;
    }

    @Override
    public <T, E extends Exception> Pool<T, E> createPool(final PoolProvider<T, E> provider) {
        PoolableObjectFactory factory = new PoolableObjectFactory<T>(){

            public void destroyObject(T object) {
                provider.close(object);
            }

            public T makeObject() throws Exception {
                return provider.create();
            }

            public boolean validateObject(T object) {
                return provider.isValid(object);
            }

            public void activateObject(T object) {
            }

            public void passivateObject(T object) {
            }
        };
        GenericObjectPool pool = new GenericObjectPool(factory, (GenericObjectPool.Config)this.config);
        return new Pool<T, E>((ObjectPool)pool, provider){
            final /* synthetic */ ObjectPool val$pool;
            final /* synthetic */ PoolProvider val$provider;
            {
                this.val$pool = objectPool;
                this.val$provider = poolProvider;
            }

            @Override
            public void close() {
                try {
                    this.val$pool.close();
                }
                catch (Exception e) {
                    logger.log(Level.WARN, e, e.getMessage(), new Object[0]);
                }
            }

            @Override
            public void release(T item) {
                try {
                    this.val$pool.returnObject(item);
                }
                catch (Exception e) {
                    logger.log(Level.WARN, e, e.getMessage(), new Object[0]);
                }
            }

            @Override
            public T take() throws Exception {
                try {
                    return this.val$pool.borrowObject();
                }
                catch (NoSuchElementException e) {
                    return this.val$provider.create();
                }
                catch (IllegalStateException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw (Exception)this.val$provider.getExceptionClass().cast(e);
                }
            }
        };
    }
}

