/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.pool.sql;

import java.sql.Connection;
import java.sql.SQLException;
import net.sf.hajdbc.pool.AbstractPoolProvider;
import net.sf.hajdbc.pool.sql.ConnectionFactory;
import net.sf.hajdbc.util.Resources;

public class ConnectionPoolProvider
extends AbstractPoolProvider<Connection, SQLException> {
    private final ConnectionFactory factory;

    public ConnectionPoolProvider(ConnectionFactory factory) {
        super(Connection.class, SQLException.class);
        this.factory = factory;
    }

    @Override
    public void close(Connection connection) {
        Resources.close(connection);
    }

    @Override
    public Connection create() throws SQLException {
        return this.factory.getConnection();
    }

    @Override
    public boolean isValid(Connection connection) {
        try {
            return connection.isValid(0);
        }
        catch (SQLException e) {
            return false;
        }
    }
}

