/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.Method;
import java.util.Map;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.sql.AbstractInvocationHandler;
import net.sf.hajdbc.sql.RootSQLProxy;
import net.sf.hajdbc.sql.SQLProxy;

public abstract class AbstractChildInvocationHandler<Z, D extends Database<Z>, P, PE extends Exception, T, E extends Exception>
extends AbstractInvocationHandler<Z, D, T, E> {
    private final P parentObject;
    private final SQLProxy<Z, D, P, PE> parentProxy;
    private final Invoker<Z, D, P, T, PE> parentInvoker;

    protected AbstractChildInvocationHandler(P parent, SQLProxy<Z, D, P, PE> proxy, Invoker<Z, D, P, T, PE> invoker, Class<T> proxyClass, Class<E> exceptionClass, Map<D, T> objectMap) {
        super(proxyClass, exceptionClass, objectMap);
        this.parentObject = parent;
        this.parentProxy = proxy;
        this.parentInvoker = invoker;
        this.parentProxy.addChild(this);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] parameters) throws Throwable {
        Method parentMethod = this.getParentMethod();
        if (parentMethod != null && method.equals(parentMethod)) {
            return this.parentObject;
        }
        return super.invoke(object, method, parameters);
    }

    protected Method getParentMethod() {
        return null;
    }

    @Override
    protected T createObject(D database) throws E {
        P object = this.parentProxy.getObject(database);
        if (object == null) {
            throw new IllegalStateException();
        }
        try {
            return this.parentInvoker.invoke(database, object);
        }
        catch (Exception e) {
            throw this.getExceptionFactory().createException(e);
        }
    }

    @Override
    protected void close(D database, T object) {
        try {
            this.close(this.parentProxy.getObject(database), object);
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, e, e.getMessage(), new Object[0]);
        }
    }

    @Override
    protected abstract void close(P var1, T var2) throws E;

    @Override
    public final RootSQLProxy<Z, D, ? extends Exception> getRoot() {
        return this.parentProxy.getRoot();
    }

    protected P getParent() {
        return this.parentObject;
    }

    protected SQLProxy<Z, D, P, PE> getParentProxy() {
        return this.parentProxy;
    }

    @Override
    public DatabaseCluster<Z, D> getDatabaseCluster() {
        return this.getRoot().getDatabaseCluster();
    }
}

