/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.codec.Decoder;
import net.sf.hajdbc.management.Description;
import net.sf.hajdbc.management.ManagedAttribute;
import net.sf.hajdbc.management.ManagedOperation;
import net.sf.hajdbc.sql.AbstractDatabaseClusterConfiguration;

@XmlType(propOrder={"user", "password", "xmlProperties"})
public abstract class AbstractDatabase<Z>
implements Database<Z> {
    @XmlAttribute(name="id", required=true)
    private String id;
    @XmlAttribute(name="location", required=true)
    private String location;
    @XmlElement(name="user")
    private String user;
    @XmlElement(name="password")
    private String password;
    @XmlAttribute(name="weight")
    private Integer weight = 1;
    @XmlAttribute(name="local")
    private Boolean local = false;
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean dirty = false;
    private volatile boolean active = false;

    @XmlElement(name="property")
    private AbstractDatabaseClusterConfiguration.Property[] getXmlProperties() {
        ArrayList<AbstractDatabaseClusterConfiguration.Property> properties = new ArrayList<AbstractDatabaseClusterConfiguration.Property>(this.properties.size());
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            AbstractDatabaseClusterConfiguration.Property property = new AbstractDatabaseClusterConfiguration.Property();
            property.setName(entry.getKey());
            property.setValue(entry.getValue());
            properties.add(property);
        }
        return properties.toArray(new AbstractDatabaseClusterConfiguration.Property[properties.size()]);
    }

    private void setXmlProperties(AbstractDatabaseClusterConfiguration.Property[] properties) {
        for (AbstractDatabaseClusterConfiguration.Property property : properties) {
            this.properties.put(property.getName(), property.getValue());
        }
    }

    @Override
    @ManagedAttribute
    @Description(value="Uniquely identifies this database in the cluster")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id.length() > 64) {
            throw new IllegalArgumentException(String.format("Must be less than %d", 64));
        }
        this.id = id;
    }

    @Override
    @ManagedAttribute
    @Description(value="Identifies the location of this database")
    public String getLocation() {
        return this.location;
    }

    @ManagedAttribute
    public void setLocation(String name) {
        this.assertInactive();
        this.checkDirty(this.location, name);
        this.location = name;
    }

    @ManagedAttribute
    @Description(value="User ID for administrative connection authentication")
    public String getUser() {
        return this.user;
    }

    @ManagedAttribute
    public void setUser(String user) {
        this.assertInactive();
        this.checkDirty(this.user, user);
        this.user = user;
    }

    @ManagedAttribute
    @Description(value="Password for administrative connection authentication")
    public String getPassword() {
        return this.password;
    }

    @ManagedAttribute
    public void setPassword(String password) {
        this.assertInactive();
        this.checkDirty(this.password, password);
        this.password = password;
    }

    @Override
    public String decodePassword(Decoder decoder) throws SQLException {
        return this.password != null ? decoder.decode(this.password) : null;
    }

    @Override
    @ManagedAttribute
    @Description(value="Weight used in read request balancing")
    public int getWeight() {
        return this.weight;
    }

    @ManagedAttribute
    public void setWeight(int weight) {
        this.assertInactive();
        if (weight < 0) {
            throw new IllegalArgumentException();
        }
        this.checkDirty(this.weight, weight);
        this.weight = weight;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Database)) {
            return false;
        }
        String id = ((Database)object).getId();
        return id != null && id.equals(this.id);
    }

    public String toString() {
        return this.id;
    }

    @Override
    public int compareTo(Database<Z> database) {
        return this.id.compareTo(database.getId());
    }

    @ManagedAttribute
    @Description(value="Connection properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @ManagedOperation
    @Description(value="Removes the specified connection property")
    public void removeProperty(String name) {
        this.assertInactive();
        String value = this.properties.remove(name);
        this.dirty |= value != null;
    }

    @ManagedOperation
    @Description(value="Creates/updates the specified connection property")
    public void setProperty(String name, String value) {
        this.assertInactive();
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        String old = this.properties.put(name, value);
        this.checkDirty(old, value);
    }

    @ManagedAttribute
    public void setLocal(boolean local) {
        this.assertInactive();
        this.checkDirty(this.local, local);
        this.local = local;
    }

    @Override
    @ManagedAttribute
    @Description(value="Indicates whether this database is local to this JVM")
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public void clean() {
        this.dirty = false;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    @ManagedAttribute
    @Description(value="Indicates whether or not this database is active")
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    protected void checkDirty(Object oldValue, Object newValue) {
        this.dirty |= oldValue != null && newValue != null ? !oldValue.equals(newValue) : oldValue != newValue;
    }

    protected boolean requiresAuthentication() {
        return this.user != null;
    }

    protected void assertInactive() {
        if (this.active) {
            throw new IllegalStateException();
        }
    }
}

