/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseClusterConfiguration;
import net.sf.hajdbc.DatabaseFactory;
import net.sf.hajdbc.ExecutorServiceProvider;
import net.sf.hajdbc.Identifiable;
import net.sf.hajdbc.IdentifiableMatcher;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.SynchronizationStrategy;
import net.sf.hajdbc.TransactionMode;
import net.sf.hajdbc.balancer.BalancerFactory;
import net.sf.hajdbc.cache.DatabaseMetaDataCacheFactory;
import net.sf.hajdbc.codec.DecoderFactory;
import net.sf.hajdbc.codec.MultiplexingDecoderFactory;
import net.sf.hajdbc.dialect.DialectFactory;
import net.sf.hajdbc.distributed.CommandDispatcherFactory;
import net.sf.hajdbc.durability.DurabilityFactory;
import net.sf.hajdbc.lock.LockManagerFactory;
import net.sf.hajdbc.management.DefaultMBeanRegistrar;
import net.sf.hajdbc.management.MBeanRegistrar;
import net.sf.hajdbc.sql.DefaultExecutorServiceProvider;
import net.sf.hajdbc.sql.TransactionModeEnum;
import net.sf.hajdbc.state.StateManagerFactory;
import net.sf.hajdbc.tx.SimpleTransactionIdentifierFactory;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;
import net.sf.hajdbc.tx.UUIDTransactionIdentifierFactory;
import net.sf.hajdbc.util.ServiceLoaders;
import net.sf.hajdbc.util.concurrent.cron.CronExpression;

@XmlType(propOrder={"commandDispatcherFactoryDescriptor", "synchronizationStrategyDescriptors", "stateManagerFactoryDescriptor", "lockManagerFactoryDescriptor"})
public abstract class AbstractDatabaseClusterConfiguration<Z, D extends Database<Z>>
implements DatabaseClusterConfiguration<Z, D> {
    private static final long serialVersionUID = -2808296483725374829L;
    private CommandDispatcherFactory dispatcherFactory;
    private Map<String, SynchronizationStrategy> synchronizationStrategies = new HashMap<String, SynchronizationStrategy>();
    private StateManagerFactory stateManagerFactory = ServiceLoaders.findRequiredService(StateManagerFactory.class);
    private LockManagerFactory lockManagerFactory = ServiceLoaders.findRequiredService(LockManagerFactory.class);

    protected abstract NestedConfiguration<Z, D> getNestedConfiguration();

    @Override
    public DatabaseFactory<Z, D> getDatabaseFactory() {
        return this.getNestedConfiguration().getDatabaseFactory();
    }

    @XmlElement(name="distributable")
    private CommandDispatcherFactoryDescriptor getCommandDispatcherFactoryDescriptor() throws Exception {
        return this.dispatcherFactory != null ? (CommandDispatcherFactoryDescriptor)new CommandDispatcherFactoryDescriptorAdapter().marshal(this.dispatcherFactory) : null;
    }

    private void setCommandDispatcherFactoryDescriptor(CommandDispatcherFactoryDescriptor descriptor) throws Exception {
        this.dispatcherFactory = descriptor != null ? (CommandDispatcherFactory)new CommandDispatcherFactoryDescriptorAdapter().unmarshal(descriptor) : null;
    }

    @XmlElement(name="sync")
    private SynchronizationStrategyDescriptor[] getSynchronizationStrategyDescriptors() throws Exception {
        ArrayList<SynchronizationStrategyDescriptor> results = new ArrayList<SynchronizationStrategyDescriptor>(this.synchronizationStrategies.size());
        SynchronizationStrategyDescriptorAdapter adapter = new SynchronizationStrategyDescriptorAdapter();
        for (Map.Entry<String, SynchronizationStrategy> entry : this.synchronizationStrategies.entrySet()) {
            SynchronizationStrategyDescriptor result = (SynchronizationStrategyDescriptor)adapter.marshal((Identifiable)entry.getValue());
            result.setId(entry.getKey());
            results.add(result);
        }
        return results.toArray(new SynchronizationStrategyDescriptor[results.size()]);
    }

    private void setSynchronizationStrategyDescriptors(SynchronizationStrategyDescriptor[] entries) throws Exception {
        SynchronizationStrategyDescriptorAdapter adapter = new SynchronizationStrategyDescriptorAdapter();
        for (SynchronizationStrategyDescriptor entry : entries) {
            SynchronizationStrategy strategy = (SynchronizationStrategy)adapter.unmarshal(entry);
            this.synchronizationStrategies.put(entry.getId(), strategy);
        }
    }

    @XmlElement(name="state")
    private StateManagerFactoryDescriptor getStateManagerFactoryDescriptor() throws Exception {
        return (StateManagerFactoryDescriptor)new StateManagerFactoryDescriptorAdapter().marshal(this.stateManagerFactory);
    }

    private void setStateManagerFactoryDescriptor(StateManagerFactoryDescriptor descriptor) throws Exception {
        this.stateManagerFactory = (StateManagerFactory)new StateManagerFactoryDescriptorAdapter().unmarshal(descriptor);
    }

    @XmlElement(name="lock")
    private LockManagerFactoryDescriptor getLockManagerFactoryDescriptor() throws Exception {
        return (LockManagerFactoryDescriptor)new LockManagerFactoryDescriptorAdapter().marshal(this.lockManagerFactory);
    }

    private void setLockManagerFactoryDescriptor(LockManagerFactoryDescriptor descriptor) throws Exception {
        this.lockManagerFactory = (LockManagerFactory)new LockManagerFactoryDescriptorAdapter().unmarshal(descriptor);
    }

    @Override
    public CronExpression getAutoActivationExpression() {
        return this.getNestedConfiguration().getAutoActivationExpression();
    }

    public void setAutoActivationExpression(CronExpression expression) {
        this.getNestedConfiguration().setAutoActivationExpression(expression);
    }

    @Override
    public BalancerFactory getBalancerFactory() {
        return this.getNestedConfiguration().getBalancerFactory();
    }

    public void setBalancerFactory(BalancerFactory factory) {
        this.getNestedConfiguration().setBalancerFactory(factory);
    }

    @Override
    public CommandDispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public void setDispatcherFactory(CommandDispatcherFactory factory) {
        this.dispatcherFactory = factory;
    }

    @Override
    public ConcurrentMap<String, D> getDatabaseMap() {
        return this.getNestedConfiguration().getDatabaseMap();
    }

    public void setDatabases(Collection<D> databases) {
        ConcurrentMap<String, D> map = this.getDatabaseMap();
        for (Database database : databases) {
            map.put(database.getId(), database);
        }
    }

    @Override
    public DatabaseMetaDataCacheFactory getDatabaseMetaDataCacheFactory() {
        return this.getNestedConfiguration().getDatabaseMetaDataCacheFactory();
    }

    public void setDatabaseMetaDataCacheFactory(DatabaseMetaDataCacheFactory factory) {
        this.getNestedConfiguration().setDatabaseMetaDataCacheFactory(factory);
    }

    @Override
    public String getDefaultSynchronizationStrategy() {
        return this.getNestedConfiguration().getDefaultSynchronizationStrategy();
    }

    public void setDefaultSynchronizationStrategy(String strategy) {
        this.getNestedConfiguration().setDefaultSynchronizationStrategy(strategy);
    }

    @Override
    public DialectFactory getDialectFactory() {
        return this.getNestedConfiguration().getDialectFactory();
    }

    public void setDialectFactory(DialectFactory factory) {
        this.getNestedConfiguration().setDialectFactory(factory);
    }

    @Override
    public DurabilityFactory getDurabilityFactory() {
        return this.getNestedConfiguration().getDurabilityFactory();
    }

    public void setDurabilityFactory(DurabilityFactory factory) {
        this.getNestedConfiguration().setDurabilityFactory(factory);
    }

    @Override
    public ExecutorServiceProvider getExecutorProvider() {
        return this.getNestedConfiguration().getExecutorProvider();
    }

    public void setExecutorProvider(ExecutorServiceProvider provider) {
        this.getNestedConfiguration().setExecutorProvider(provider);
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.getNestedConfiguration().getThreadFactory();
    }

    public void setThreadFactory(ThreadFactory factory) {
        this.getNestedConfiguration().setThreadFactory(factory);
    }

    @Override
    public DecoderFactory getDecoderFactory() {
        return this.getNestedConfiguration().getDecoderFactory();
    }

    public void setCodecFactory(DecoderFactory factory) {
        this.getNestedConfiguration().setDecoderFactory(factory);
    }

    @Override
    public CronExpression getFailureDetectionExpression() {
        return this.getNestedConfiguration().getFailureDetectionExpression();
    }

    public void setFailureDetectionExpression(CronExpression expression) {
        this.getNestedConfiguration().setFailureDetectionExpression(expression);
    }

    @Override
    public StateManagerFactory getStateManagerFactory() {
        return this.stateManagerFactory;
    }

    public void setStateManagerFactory(StateManagerFactory factory) {
        this.stateManagerFactory = factory;
    }

    @Override
    public LockManagerFactory getLockManagerFactory() {
        return this.lockManagerFactory;
    }

    public void setLockManagerFactory(LockManagerFactory factory) {
        this.lockManagerFactory = factory;
    }

    @Override
    public Map<String, SynchronizationStrategy> getSynchronizationStrategyMap() {
        return this.synchronizationStrategies;
    }

    public void setSynchronizationStrategyMap(Map<String, SynchronizationStrategy> strategies) {
        this.synchronizationStrategies = strategies;
    }

    @Override
    public TransactionMode getTransactionMode() {
        return this.getNestedConfiguration().getTransactionMode();
    }

    public void setTransactionMode(TransactionMode mode) {
        this.getNestedConfiguration().setTransactionMode(mode);
    }

    @Override
    public boolean isCurrentDateEvaluationEnabled() {
        return this.getNestedConfiguration().isCurrentDateEvaluationEnabled();
    }

    public void setCurrentDateEvaluationEnabled(boolean enabled) {
        this.getNestedConfiguration().setCurrentDateEvaluationEnabled(enabled);
    }

    @Override
    public boolean isCurrentTimeEvaluationEnabled() {
        return this.getNestedConfiguration().isCurrentTimeEvaluationEnabled();
    }

    public void setCurrentTimeEvaluationEnabled(boolean enabled) {
        this.getNestedConfiguration().setCurrentTimeEvaluationEnabled(enabled);
    }

    @Override
    public boolean isCurrentTimestampEvaluationEnabled() {
        return this.getNestedConfiguration().isCurrentTimestampEvaluationEnabled();
    }

    public void setCurrentTimestampEvaluationEnabled(boolean enabled) {
        this.getNestedConfiguration().setCurrentTimestampEvaluationEnabled(enabled);
    }

    @Override
    public boolean isIdentityColumnDetectionEnabled() {
        return this.getNestedConfiguration().isIdentityColumnDetectionEnabled();
    }

    public void setIdentityColumnDetectionEnabled(boolean enabled) {
        this.getNestedConfiguration().setIdentityColumnDetectionEnabled(enabled);
    }

    @Override
    public boolean isRandEvaluationEnabled() {
        return this.getNestedConfiguration().isRandEvaluationEnabled();
    }

    public void setRandEvaluationEnabled(boolean enabled) {
        this.getNestedConfiguration().setRandEvaluationEnabled(enabled);
    }

    @Override
    public boolean isSequenceDetectionEnabled() {
        return this.getNestedConfiguration().isSequenceDetectionEnabled();
    }

    public void setSequenceDetectionEnabled(boolean enabled) {
        this.getNestedConfiguration().setSequenceDetectionEnabled(enabled);
    }

    static Map<String, Map.Entry<PropertyDescriptor, PropertyEditor>> findDescriptors(Class<?> targetClass) throws Exception {
        HashMap<String, Map.Entry<PropertyDescriptor, PropertyEditor>> map = new HashMap<String, Map.Entry<PropertyDescriptor, PropertyEditor>>();
        for (PropertyDescriptor descriptor : Introspector.getBeanInfo(targetClass).getPropertyDescriptors()) {
            PropertyEditor editor;
            if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null || (editor = PropertyEditorManager.findEditor(descriptor.getPropertyType())) == null) continue;
            map.put(descriptor.getName(), new AbstractMap.SimpleImmutableEntry<PropertyDescriptor, PropertyEditor>(descriptor, editor));
        }
        return map;
    }

    @Override
    public MBeanRegistrar<Z, D> getMBeanRegistrar() {
        return this.getNestedConfiguration().getMBeanRegistrar();
    }

    public void setMBeanRegistrar(MBeanRegistrar<Z, D> registrar) {
        this.getNestedConfiguration().setMBeanRegistrar(registrar);
    }

    @Override
    public boolean isEmptyClusterAllowed() {
        return this.getNestedConfiguration().isEmptyClusterAllowed();
    }

    public void setEmptyClusterAllowed(boolean emptyClusterAllowed) {
        this.getNestedConfiguration().setEmptyClusterAllowed(emptyClusterAllowed);
    }

    @Override
    public TransactionIdentifierFactory<? extends Object> getTransactionIdentifierFactory() {
        return this.dispatcherFactory != null ? new UUIDTransactionIdentifierFactory() : new SimpleTransactionIdentifierFactory();
    }

    @XmlType
    protected static class Property {
        @XmlAttribute(required=true)
        private String name;
        @XmlValue
        private String value;

        protected Property() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    static class IdentifiableServiceDescriptorAdapter<T extends Identifiable, D extends IdentifiableServiceDescriptor>
    extends XmlAdapter<D, T> {
        private final Class<T> serviceClass;
        private final Class<D> descriptorClass;

        IdentifiableServiceDescriptorAdapter(Class<T> serviceClass, Class<D> descriptorClass) {
            this.serviceClass = serviceClass;
            this.descriptorClass = descriptorClass;
        }

        public D marshal(T object) throws Exception {
            IdentifiableServiceDescriptor result = (IdentifiableServiceDescriptor)this.descriptorClass.newInstance();
            LinkedList<Property> properties = new LinkedList<Property>();
            result.setId(object.getId());
            result.setProperties(properties);
            for (Map.Entry<PropertyDescriptor, PropertyEditor> entry : AbstractDatabaseClusterConfiguration.findDescriptors(object.getClass()).values()) {
                PropertyDescriptor descriptor = entry.getKey();
                PropertyEditor editor = entry.getValue();
                Object value = descriptor.getReadMethod().invoke(object, new Object[0]);
                if (value == null) continue;
                editor.setValue(value);
                Property property = new Property();
                property.setName(descriptor.getName());
                property.setValue(editor.getAsText());
                properties.add(property);
            }
            return (D)result;
        }

        public T unmarshal(D target) throws Exception {
            Identifiable result = (Identifiable)ServiceLoaders.findRequiredService(new IdentifiableMatcher(target.getId()), this.serviceClass);
            List<Property> properties = ((IdentifiableServiceDescriptor)target).getProperties();
            if (properties != null) {
                Map<String, Map.Entry<PropertyDescriptor, PropertyEditor>> descriptors = AbstractDatabaseClusterConfiguration.findDescriptors(result.getClass());
                for (Property property : properties) {
                    String name = property.getName();
                    Map.Entry<PropertyDescriptor, PropertyEditor> entry = descriptors.get(name);
                    if (entry == null) {
                        throw new IllegalArgumentException(Messages.INVALID_PROPERTY.getMessage(name, result.getClass().getName()));
                    }
                    PropertyDescriptor descriptor = entry.getKey();
                    PropertyEditor editor = entry.getValue();
                    String textValue = property.getValue();
                    try {
                        editor.setAsText(textValue);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(Messages.INVALID_PROPERTY_VALUE.getMessage(textValue, name, result.getClass().getName()));
                    }
                    descriptor.getWriteMethod().invoke((Object)result, editor.getValue());
                }
            }
            return (T)result;
        }
    }

    static abstract class IdentifiableServiceDescriptor
    implements Identifiable {
        @XmlElement(name="property")
        private List<Property> properties;

        IdentifiableServiceDescriptor() {
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public void setProperties(List<Property> properties) {
            this.properties = properties;
        }

        public abstract void setId(String var1);
    }

    static class LockManagerFactoryDescriptorAdapter
    extends IdentifiableServiceDescriptorAdapter<LockManagerFactory, LockManagerFactoryDescriptor> {
        LockManagerFactoryDescriptorAdapter() {
            super(LockManagerFactory.class, LockManagerFactoryDescriptor.class);
        }
    }

    @XmlType
    static class LockManagerFactoryDescriptor
    extends IdentifiableServiceDescriptor {
        @XmlAttribute(name="id", required=true)
        private String id;

        LockManagerFactoryDescriptor() {
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            this.id = id;
        }
    }

    static class StateManagerFactoryDescriptorAdapter
    extends IdentifiableServiceDescriptorAdapter<StateManagerFactory, StateManagerFactoryDescriptor> {
        StateManagerFactoryDescriptorAdapter() {
            super(StateManagerFactory.class, StateManagerFactoryDescriptor.class);
        }
    }

    @XmlType
    static class StateManagerFactoryDescriptor
    extends IdentifiableServiceDescriptor {
        @XmlAttribute(name="id", required=true)
        private String id;

        StateManagerFactoryDescriptor() {
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            this.id = id;
        }
    }

    static class SynchronizationStrategyDescriptorAdapter
    extends IdentifiableServiceDescriptorAdapter<SynchronizationStrategy, SynchronizationStrategyDescriptor> {
        SynchronizationStrategyDescriptorAdapter() {
            super(SynchronizationStrategy.class, SynchronizationStrategyDescriptor.class);
        }
    }

    @XmlType
    static class SynchronizationStrategyDescriptor
    extends IdentifiableServiceDescriptor {
        @XmlID
        @XmlAttribute(name="id", required=true)
        private String id;

        SynchronizationStrategyDescriptor() {
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            this.id = id;
        }
    }

    static class CommandDispatcherFactoryDescriptorAdapter
    extends IdentifiableServiceDescriptorAdapter<CommandDispatcherFactory, CommandDispatcherFactoryDescriptor> {
        CommandDispatcherFactoryDescriptorAdapter() {
            super(CommandDispatcherFactory.class, CommandDispatcherFactoryDescriptor.class);
        }
    }

    @XmlType
    static class CommandDispatcherFactoryDescriptor
    extends IdentifiableServiceDescriptor {
        @XmlAttribute(name="id", required=false)
        private String id = "jgroups";

        CommandDispatcherFactoryDescriptor() {
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(String id) {
            this.id = id;
        }
    }

    static class CronExpressionAdapter
    extends XmlAdapter<String, CronExpression> {
        CronExpressionAdapter() {
        }

        public String marshal(CronExpression expression) {
            return expression != null ? expression.getCronExpression() : null;
        }

        public CronExpression unmarshal(String value) throws Exception {
            return value != null ? new CronExpression(value) : null;
        }
    }

    static class DialectFactoryAdapter
    extends IdentifiableServiceAdapter<DialectFactory> {
        DialectFactoryAdapter() {
            super(DialectFactory.class);
        }
    }

    static abstract class EnumAdapter<I, E extends I>
    extends XmlAdapter<E, I> {
        EnumAdapter() {
        }

        public I unmarshal(E enumerated) throws Exception {
            return (I)enumerated;
        }

        public E marshal(I object) throws Exception {
            return this.getTargetClass().cast(object);
        }

        protected abstract Class<E> getTargetClass();
    }

    static class TransactionModeAdapter
    extends EnumAdapter<TransactionMode, TransactionModeEnum> {
        TransactionModeAdapter() {
        }

        @Override
        protected Class<TransactionModeEnum> getTargetClass() {
            return TransactionModeEnum.class;
        }
    }

    static class DurabilityFactoryAdapter
    extends IdentifiableServiceAdapter<DurabilityFactory> {
        DurabilityFactoryAdapter() {
            super(DurabilityFactory.class);
        }
    }

    static class DatabaseMetaDataCacheFactoryAdapter
    extends IdentifiableServiceAdapter<DatabaseMetaDataCacheFactory> {
        DatabaseMetaDataCacheFactoryAdapter() {
            super(DatabaseMetaDataCacheFactory.class);
        }
    }

    static class BalancerFactoryAdapter
    extends IdentifiableServiceAdapter<BalancerFactory> {
        BalancerFactoryAdapter() {
            super(BalancerFactory.class);
        }
    }

    static class IdentifiableServiceAdapter<T extends Identifiable>
    extends XmlAdapter<String, T> {
        private final Class<T> serviceClass;

        IdentifiableServiceAdapter(Class<T> serviceClass) {
            this.serviceClass = serviceClass;
        }

        public T unmarshal(String value) throws Exception {
            return (T)((Identifiable)ServiceLoaders.findRequiredService(new IdentifiableMatcher(value), this.serviceClass));
        }

        public String marshal(T service) throws Exception {
            return service.getId();
        }
    }

    @XmlType(name="abstractNestedConfiguration")
    protected static abstract class NestedConfiguration<Z, D extends Database<Z>>
    implements DatabaseClusterConfiguration<Z, D>,
    DatabaseFactory<Z, D> {
        private static final long serialVersionUID = -5674156614205147546L;
        @XmlJavaTypeAdapter(value=BalancerFactoryAdapter.class)
        @XmlAttribute(name="balancer")
        private BalancerFactory balancerFactory = ServiceLoaders.findService(BalancerFactory.class);
        @XmlJavaTypeAdapter(value=DatabaseMetaDataCacheFactoryAdapter.class)
        @XmlAttribute(name="meta-data-cache")
        private DatabaseMetaDataCacheFactory databaseMetaDataCacheFactory = ServiceLoaders.findService(DatabaseMetaDataCacheFactory.class);
        @XmlJavaTypeAdapter(value=DialectFactoryAdapter.class)
        @XmlAttribute(name="dialect")
        private DialectFactory dialectFactory = ServiceLoaders.findService(DialectFactory.class);
        @XmlJavaTypeAdapter(value=DurabilityFactoryAdapter.class)
        @XmlAttribute(name="durability")
        private DurabilityFactory durabilityFactory = ServiceLoaders.findService(DurabilityFactory.class);
        private ExecutorServiceProvider executorProvider = new DefaultExecutorServiceProvider();
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();
        private DecoderFactory decoderFactory = new MultiplexingDecoderFactory();
        private MBeanRegistrar<Z, D> registrar = new DefaultMBeanRegistrar();
        @XmlJavaTypeAdapter(value=TransactionModeAdapter.class)
        @XmlAttribute(name="transaction-mode")
        private TransactionMode transactionMode = TransactionModeEnum.SERIAL;
        @XmlJavaTypeAdapter(value=CronExpressionAdapter.class)
        @XmlAttribute(name="auto-activate-schedule")
        private CronExpression autoActivationExpression;
        @XmlJavaTypeAdapter(value=CronExpressionAdapter.class)
        @XmlAttribute(name="failure-detect-schedule")
        private CronExpression failureDetectionExpression;
        @XmlAttribute(name="eval-current-date")
        private Boolean currentDateEvaluationEnabled = false;
        @XmlAttribute(name="eval-current-time")
        private Boolean currentTimeEvaluationEnabled = false;
        @XmlAttribute(name="eval-current-timestamp")
        private Boolean currentTimestampEvaluationEnabled = false;
        @XmlAttribute(name="eval-rand")
        private Boolean randEvaluationEnabled = false;
        @XmlAttribute(name="detect-identity-columns")
        private Boolean identityColumnDetectionEnabled = false;
        @XmlAttribute(name="detect-sequences")
        private Boolean sequenceDetectionEnabled = false;
        @XmlAttribute(name="allow-empty-cluster")
        private Boolean emptyClusterAllowed = false;
        private String defaultSynchronizationStrategy;
        private ConcurrentMap<String, D> databases = new ConcurrentHashMap<String, D>();

        protected NestedConfiguration() {
        }

        @Override
        public DatabaseFactory<Z, D> getDatabaseFactory() {
            return this;
        }

        @XmlIDREF
        @XmlAttribute(name="default-sync", required=true)
        private SynchronizationStrategyDescriptor getDefaultSynchronizationStrategyDescriptor() {
            SynchronizationStrategyDescriptor descriptor = new SynchronizationStrategyDescriptor();
            descriptor.setId(this.defaultSynchronizationStrategy);
            return descriptor;
        }

        private void setDefaultSynchronizationStrategyDescriptor(SynchronizationStrategyDescriptor descriptor) {
            this.defaultSynchronizationStrategy = descriptor.getId();
        }

        @Override
        public ConcurrentMap<String, D> getDatabaseMap() {
            return this.databases;
        }

        @Override
        public CronExpression getAutoActivationExpression() {
            return this.autoActivationExpression;
        }

        void setAutoActivationExpression(CronExpression expression) {
            this.autoActivationExpression = expression;
        }

        @Override
        public BalancerFactory getBalancerFactory() {
            return this.balancerFactory;
        }

        void setBalancerFactory(BalancerFactory factory) {
            this.balancerFactory = factory;
        }

        @Override
        public CommandDispatcherFactory getDispatcherFactory() {
            throw new IllegalStateException();
        }

        @Override
        public DatabaseMetaDataCacheFactory getDatabaseMetaDataCacheFactory() {
            return this.databaseMetaDataCacheFactory;
        }

        void setDatabaseMetaDataCacheFactory(DatabaseMetaDataCacheFactory factory) {
            this.databaseMetaDataCacheFactory = factory;
        }

        @Override
        public String getDefaultSynchronizationStrategy() {
            return this.defaultSynchronizationStrategy;
        }

        void setDefaultSynchronizationStrategy(String strategy) {
            this.defaultSynchronizationStrategy = strategy;
        }

        @Override
        public DialectFactory getDialectFactory() {
            return this.dialectFactory;
        }

        void setDialectFactory(DialectFactory factory) {
            this.dialectFactory = factory;
        }

        @Override
        public DurabilityFactory getDurabilityFactory() {
            return this.durabilityFactory;
        }

        void setDurabilityFactory(DurabilityFactory factory) {
            this.durabilityFactory = factory;
        }

        @Override
        public ExecutorServiceProvider getExecutorProvider() {
            return this.executorProvider;
        }

        void setExecutorProvider(ExecutorServiceProvider provider) {
            this.executorProvider = provider;
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        void setThreadFactory(ThreadFactory factory) {
            this.threadFactory = factory;
        }

        @Override
        public DecoderFactory getDecoderFactory() {
            return this.decoderFactory;
        }

        void setDecoderFactory(DecoderFactory factory) {
            this.decoderFactory = factory;
        }

        @Override
        public MBeanRegistrar<Z, D> getMBeanRegistrar() {
            return this.registrar;
        }

        void setMBeanRegistrar(MBeanRegistrar<Z, D> registrar) {
            this.registrar = registrar;
        }

        @Override
        public CronExpression getFailureDetectionExpression() {
            return this.failureDetectionExpression;
        }

        void setFailureDetectionExpression(CronExpression expression) {
            this.failureDetectionExpression = expression;
        }

        @Override
        public StateManagerFactory getStateManagerFactory() {
            throw new IllegalStateException();
        }

        @Override
        public LockManagerFactory getLockManagerFactory() {
            throw new IllegalStateException();
        }

        @Override
        public Map<String, SynchronizationStrategy> getSynchronizationStrategyMap() {
            throw new IllegalStateException();
        }

        @Override
        public TransactionMode getTransactionMode() {
            return this.transactionMode;
        }

        void setTransactionMode(TransactionMode mode) {
            this.transactionMode = mode;
        }

        @Override
        public boolean isCurrentDateEvaluationEnabled() {
            return this.currentDateEvaluationEnabled;
        }

        void setCurrentDateEvaluationEnabled(boolean enabled) {
            this.currentDateEvaluationEnabled = enabled;
        }

        @Override
        public boolean isCurrentTimeEvaluationEnabled() {
            return this.currentTimeEvaluationEnabled;
        }

        void setCurrentTimeEvaluationEnabled(boolean enabled) {
            this.currentTimeEvaluationEnabled = enabled;
        }

        @Override
        public boolean isCurrentTimestampEvaluationEnabled() {
            return this.currentTimestampEvaluationEnabled;
        }

        void setCurrentTimestampEvaluationEnabled(boolean enabled) {
            this.currentTimestampEvaluationEnabled = enabled;
        }

        @Override
        public boolean isIdentityColumnDetectionEnabled() {
            return this.identityColumnDetectionEnabled;
        }

        void setIdentityColumnDetectionEnabled(boolean enabled) {
            this.identityColumnDetectionEnabled = enabled;
        }

        @Override
        public boolean isRandEvaluationEnabled() {
            return this.randEvaluationEnabled;
        }

        void setRandEvaluationEnabled(boolean enabled) {
            this.randEvaluationEnabled = enabled;
        }

        @Override
        public boolean isSequenceDetectionEnabled() {
            return this.sequenceDetectionEnabled;
        }

        void setSequenceDetectionEnabled(boolean enabled) {
            this.sequenceDetectionEnabled = enabled;
        }

        @Override
        public TransactionIdentifierFactory<? extends Object> getTransactionIdentifierFactory() {
            throw new IllegalStateException();
        }

        @Override
        public boolean isEmptyClusterAllowed() {
            return this.emptyClusterAllowed;
        }

        void setEmptyClusterAllowed(boolean emptyClusterAllowed) {
            this.emptyClusterAllowed = emptyClusterAllowed;
        }
    }
}

