/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.WeakHashMap;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionFactory;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.sql.InvocationHandlerFactory;
import net.sf.hajdbc.sql.InvocationResultFactory;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.util.Objects;
import net.sf.hajdbc.util.reflect.Methods;
import net.sf.hajdbc.util.reflect.ProxyFactory;

public abstract class AbstractInvocationHandler<Z, D extends Database<Z>, T, E extends Exception>
implements InvocationHandler,
SQLProxy<Z, D, T, E> {
    private static final Method equalsMethod = Methods.getMethod(Object.class, "equals", Object.class);
    private static final Method hashCodeMethod = Methods.getMethod(Object.class, "hashCode", new Class[0]);
    private static final Method toStringMethod = Methods.getMethod(Object.class, "toString", new Class[0]);
    private static final Set<Method> wrapperMethods = Methods.findMethods(Wrapper.class, "isWrapperFor", "unwrap");
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<T> proxyClass;
    private final Map<D, T> objectMap;
    private final Map<SQLProxy<Z, D, ?, ? extends Exception>, Void> childMap = new WeakHashMap();
    private final Map<Method, Invoker<Z, D, T, ?, E>> invokerMap = new HashMap();
    private final Class<E> exceptionClass;

    protected AbstractInvocationHandler(Class<T> proxyClass, Class<E> exceptionClass, Map<D, T> objectMap) {
        this.proxyClass = proxyClass;
        this.exceptionClass = exceptionClass;
        this.objectMap = objectMap;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] parameters) throws Throwable {
        DatabaseCluster cluster = this.getDatabaseCluster();
        if (!cluster.isActive()) {
            throw new SQLException(Messages.CLUSTER_NOT_ACTIVE.getMessage(cluster));
        }
        return this.invokeOnProxy(this.proxyClass.cast(object), method, parameters);
    }

    private <R> R invokeOnProxy(T object, Method method, Object[] parameters) throws E {
        InvocationStrategy strategy = this.getInvocationStrategy(object, method, parameters);
        Invoker<Z, D, T, R, E> invoker = this.getInvoker(object, method, parameters);
        this.logger.log(Level.TRACE, "Invoking {0} using {1}", method, strategy.getClass().getName());
        SortedMap<D, R> results = strategy.invoke(this, invoker);
        this.record(invoker, method, parameters);
        this.postInvoke(object, method, parameters);
        InvocationHandlerFactory<Z, D, T, ?, E> handlerFactory = this.getInvocationHandlerFactory(object, method, parameters);
        InvocationResultFactory resultFactory = handlerFactory != null ? new ProxyInvocationResultFactory(handlerFactory, object, invoker) : new SimpleInvocationResultFactory();
        return resultFactory.createResult(results);
    }

    protected InvocationHandlerFactory<Z, D, T, ?, E> getInvocationHandlerFactory(T object, Method method, Object[] parameters) throws E {
        return null;
    }

    protected InvocationStrategy getInvocationStrategy(T object, Method method, Object[] parameters) throws E {
        if (method.equals(equalsMethod) || method.equals(hashCodeMethod) || method.equals(toStringMethod) || wrapperMethods.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ANY;
        }
        return InvocationStrategyEnum.INVOKE_ON_ALL;
    }

    protected <R> Invoker<Z, D, T, R, E> getInvoker(T object, Method method, Object[] parameters) throws E {
        if (this.isSQLMethod(method)) {
            ArrayList<Object> parameterList = new ArrayList<Object>(Arrays.asList(parameters));
            long now = System.currentTimeMillis();
            DatabaseCluster cluster = this.getDatabaseCluster();
            Dialect dialect = cluster.getDialect();
            if (cluster.isCurrentTimestampEvaluationEnabled()) {
                parameterList.set(0, dialect.evaluateCurrentTimestamp((String)parameterList.get(0), new Timestamp(now)));
            }
            if (cluster.isCurrentDateEvaluationEnabled()) {
                parameterList.set(0, dialect.evaluateCurrentDate((String)parameterList.get(0), new Date(now)));
            }
            if (cluster.isCurrentTimeEvaluationEnabled()) {
                parameterList.set(0, dialect.evaluateCurrentTime((String)parameterList.get(0), new Time(now)));
            }
            if (cluster.isRandEvaluationEnabled()) {
                parameterList.set(0, dialect.evaluateRand((String)parameterList.get(0)));
            }
            return new SimpleInvoker(method, parameterList.toArray());
        }
        return new SimpleInvoker(method, parameters);
    }

    protected boolean isSQLMethod(Method method) {
        return false;
    }

    protected void postInvoke(T proxy, Method method, Object[] parameters) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<D, T>> entries() {
        Map<D, T> map = this.objectMap;
        synchronized (map) {
            return this.objectMap.entrySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addChild(SQLProxy<Z, D, ?, ? extends Exception> child) {
        Map<SQLProxy<Z, D, ?, ? extends Exception>, Void> map = this.childMap;
        synchronized (map) {
            this.childMap.put(child, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeChildren() {
        Map<SQLProxy<Z, D, ?, ? extends Exception>, Void> map = this.childMap;
        synchronized (map) {
            this.childMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeChild(SQLProxy<Z, D, ?, ? extends Exception> child) {
        child.removeChildren();
        Map<SQLProxy<Z, D, ?, ? extends Exception>, Void> map = this.childMap;
        synchronized (map) {
            this.childMap.remove(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getObject(D database) {
        Map<D, T> map = this.objectMap;
        synchronized (map) {
            T object;
            block6: {
                object = this.objectMap.get(database);
                if (object == null) {
                    try {
                        object = this.createObject(database);
                        this.replay(database, object);
                        this.objectMap.put(database, object);
                    }
                    catch (Throwable e) {
                        DatabaseCluster cluster = this.getDatabaseCluster();
                        if (this.objectMap.isEmpty() || !cluster.deactivate(database, cluster.getStateManager())) break block6;
                        this.logger.log(Level.WARN, e, Messages.SQL_OBJECT_INIT_FAILED.getMessage(new Object[0]), this.getClass().getName(), database);
                    }
                }
            }
            return object;
        }
    }

    protected abstract T createObject(D var1) throws E;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void record(Invoker<Z, D, T, ?, E> invoker, Method method, Object[] parameters) {
        if (this.isRecordable(method)) {
            Map<Method, Invoker<Z, D, T, ?, E>> map = this.invokerMap;
            synchronized (map) {
                this.invokerMap.put(method, invoker);
            }
        }
    }

    protected boolean isRecordable(Method method) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replay(D database, T object) throws E {
        Map<Method, Invoker<Z, D, T, ?, E>> map = this.invokerMap;
        synchronized (map) {
            for (Invoker<Z, D, T, ?, E> invoker : this.invokerMap.values()) {
                this.logger.log(Level.TRACE, "Replaying against database {0}: {1}.{2}", database, object.getClass().getName(), invoker);
                invoker.invoke(database, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void retain(Set<D> databaseSet) {
        Map<SQLProxy<Z, D, Object, Exception>, Void> map = this.childMap;
        synchronized (map) {
            for (SQLProxy<Z, D, ?, Exception> child : this.childMap.keySet()) {
                child.retain(databaseSet);
            }
        }
        map = this.objectMap;
        synchronized (map) {
            Iterator<Map.Entry<D, T>> mapEntries = this.objectMap.entrySet().iterator();
            while (mapEntries.hasNext()) {
                Map.Entry<D, T> mapEntry = mapEntries.next();
                Database database = (Database)mapEntry.getKey();
                if (databaseSet.contains(database)) continue;
                T object = mapEntry.getValue();
                if (object != null) {
                    this.close(database, object);
                }
                mapEntries.remove();
            }
        }
    }

    protected abstract void close(D var1, T var2);

    protected <A> SQLProxy<Z, D, A, E> getInvocationHandler(A proxy) {
        return (SQLProxy)((Object)Proxy.getInvocationHandler(proxy));
    }

    @Override
    public final ExceptionFactory<E> getExceptionFactory() {
        return ExceptionType.getExceptionFactory(this.exceptionClass);
    }

    class ProxyInvocationResultFactory<R>
    implements InvocationResultFactory<Z, D, R, E> {
        private final InvocationHandlerFactory<Z, D, T, R, E> factory;
        private final T object;
        private final Invoker<Z, D, T, R, E> invoker;

        ProxyInvocationResultFactory(InvocationHandlerFactory<Z, D, T, R, E> factory, T object, Invoker<Z, D, T, R, E> invoker) {
            this.factory = factory;
            this.object = object;
            this.invoker = invoker;
        }

        @Override
        public R createResult(SortedMap<D, R> results) throws Exception {
            return ProxyFactory.createProxy(this.factory.getTargetClass(), this.factory.createInvocationHandler(this.object, AbstractInvocationHandler.this, this.invoker, results));
        }
    }

    class SimpleInvocationResultFactory<R>
    implements InvocationResultFactory<Z, D, R, E> {
        SimpleInvocationResultFactory() {
        }

        @Override
        public R createResult(SortedMap<D, R> resultMap) {
            assert (!resultMap.isEmpty());
            DatabaseCluster cluster = AbstractInvocationHandler.this.getDatabaseCluster();
            Iterator results = resultMap.entrySet().iterator();
            R primaryResult = results.next().getValue();
            while (results.hasNext()) {
                Database database;
                Map.Entry entry = results.next();
                R result = entry.getValue();
                if (Objects.equals(primaryResult, result) || !cluster.deactivate(database = (Database)entry.getKey(), cluster.getStateManager())) continue;
                AbstractInvocationHandler.this.logger.log(Level.ERROR, Messages.DATABASE_INCONSISTENT.getMessage(new Object[0]), database, cluster, primaryResult, result);
            }
            return primaryResult;
        }
    }

    protected class SimpleInvoker<R>
    implements Invoker<Z, D, T, R, E> {
        private final Method method;
        private final Object[] parameters;

        public SimpleInvoker(Method method, Object[] parameters) {
            this.method = method;
            this.parameters = parameters;
        }

        @Override
        public R invoke(D database, T object) throws Exception {
            return Methods.invoke(this.method, AbstractInvocationHandler.this.getExceptionFactory(), object, this.parameters);
        }

        public String toString() {
            return this.method.toString();
        }
    }
}

