/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.AbstractStatementInvocationHandler;
import net.sf.hajdbc.sql.FileSupport;
import net.sf.hajdbc.sql.InvocationHandlerFactory;
import net.sf.hajdbc.sql.LockingInvocationStrategy;
import net.sf.hajdbc.sql.ResultSetInvocationHandlerFactory;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.sql.TransactionContext;
import net.sf.hajdbc.util.reflect.Methods;
import net.sf.hajdbc.util.reflect.ProxyFactory;
import net.sf.hajdbc.util.reflect.SimpleInvocationHandler;

public abstract class AbstractPreparedStatementInvocationHandler<Z, D extends Database<Z>, S extends PreparedStatement>
extends AbstractStatementInvocationHandler<Z, D, S> {
    private static final Set<Method> databaseReadMethodSet = Methods.findMethods(PreparedStatement.class, "getMetaData", "getParameterMetaData");
    private static final Method executeMethod = Methods.getMethod(PreparedStatement.class, "execute", new Class[0]);
    private static final Method executeUpdateMethod = Methods.getMethod(PreparedStatement.class, "executeUpdate", new Class[0]);
    private static final Method executeQueryMethod = Methods.getMethod(PreparedStatement.class, "executeQuery", new Class[0]);
    private static final Method clearParametersMethod = Methods.getMethod(PreparedStatement.class, "clearParameters", new Class[0]);
    private static final Method addBatchMethod = Methods.getMethod(PreparedStatement.class, "addBatch", new Class[0]);
    protected List<Lock> lockList = Collections.emptyList();
    protected boolean selectForUpdate = false;
    private final Set<Method> setMethodSet;

    protected AbstractPreparedStatementInvocationHandler(Connection connection, SQLProxy<Z, D, Connection, SQLException> proxy, Invoker<Z, D, Connection, S, SQLException> invoker, Class<S> statementClass, Map<D, S> statementMap, TransactionContext<Z, D> transactionContext, FileSupport<SQLException> fileSupport, Set<Method> setMethodSet) {
        super(connection, proxy, invoker, statementClass, statementMap, transactionContext, fileSupport);
        this.setMethodSet = setMethodSet;
    }

    @Override
    protected InvocationHandlerFactory<Z, D, S, ?, SQLException> getInvocationHandlerFactory(S object, Method method, Object[] parameters) throws SQLException {
        if (method.equals(executeQueryMethod)) {
            return new ResultSetInvocationHandlerFactory(this.transactionContext, this.fileSupport);
        }
        return super.getInvocationHandlerFactory(object, method, parameters);
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(S statement, Method method, Object[] parameters) throws SQLException {
        if (databaseReadMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_NEXT;
        }
        if (this.setMethodSet.contains(method) || method.equals(clearParametersMethod) || method.equals(addBatchMethod)) {
            return InvocationStrategyEnum.INVOKE_ON_EXISTING;
        }
        if (method.equals(executeMethod) || method.equals(executeUpdateMethod)) {
            return this.transactionContext.start(new LockingInvocationStrategy(InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL, this.lockList), (Connection)this.getParent());
        }
        if (method.equals(executeQueryMethod)) {
            int concurrency = statement.getResultSetConcurrency();
            if (this.lockList.isEmpty() && concurrency == 1007 && !this.selectForUpdate) {
                return InvocationStrategyEnum.INVOKE_ON_NEXT;
            }
            LockingInvocationStrategy strategy = new LockingInvocationStrategy(InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL, this.lockList);
            return this.selectForUpdate ? this.transactionContext.start(strategy, (Connection)this.getParent()) : strategy;
        }
        return super.getInvocationStrategy(statement, method, parameters);
    }

    @Override
    protected <R> Invoker<Z, D, S, R, SQLException> getInvoker(S statement, final Method method, final Object[] parameters) throws SQLException {
        Object typeParameter;
        if (this.isParameterSetMethod(method) && parameters.length > 1 && (typeParameter = parameters[1]) != null) {
            Class<?> type = method.getParameterTypes()[1];
            if (type.equals(InputStream.class)) {
                final File file = this.fileSupport.createFile((InputStream)typeParameter);
                return new Invoker<Z, D, S, R, SQLException>(){

                    @Override
                    public R invoke(D database, S statement) throws SQLException {
                        ArrayList<Object> parameterList = new ArrayList<Object>(Arrays.asList(parameters));
                        parameterList.set(1, AbstractPreparedStatementInvocationHandler.this.fileSupport.getInputStream(file));
                        return Methods.invoke(method, AbstractPreparedStatementInvocationHandler.this.getExceptionFactory(), statement, parameterList.toArray());
                    }
                };
            }
            if (type.equals(Reader.class)) {
                final File file = this.fileSupport.createFile((Reader)typeParameter);
                return new Invoker<Z, D, S, R, SQLException>(){

                    @Override
                    public R invoke(D database, S statement) throws SQLException {
                        ArrayList<Object> parameterList = new ArrayList<Object>(Arrays.asList(parameters));
                        parameterList.set(1, AbstractPreparedStatementInvocationHandler.this.fileSupport.getReader(file));
                        return Methods.invoke(method, AbstractPreparedStatementInvocationHandler.this.getExceptionFactory(), statement, parameterList.toArray());
                    }
                };
            }
            if (type.equals(Blob.class)) {
                Blob blob = (Blob)typeParameter;
                if (Proxy.isProxyClass(blob.getClass()) && Proxy.getInvocationHandler(blob) instanceof SQLProxy) {
                    final SQLProxy proxy = this.getInvocationHandler(blob);
                    return new Invoker<Z, D, S, R, SQLException>(){

                        @Override
                        public R invoke(D database, S statement) throws SQLException {
                            ArrayList<Object> parameterList = new ArrayList<Object>(Arrays.asList(parameters));
                            parameterList.set(1, proxy.getObject(database));
                            return Methods.invoke(method, AbstractPreparedStatementInvocationHandler.this.getExceptionFactory(), statement, parameterList.toArray());
                        }
                    };
                }
                parameters[1] = new SerialBlob(blob);
            }
            if (Clob.class.isAssignableFrom(type)) {
                Clob clob = (Clob)typeParameter;
                if (Proxy.isProxyClass(clob.getClass()) && Proxy.getInvocationHandler(clob) instanceof SQLProxy) {
                    final SQLProxy proxy = this.getInvocationHandler(clob);
                    return new Invoker<Z, D, S, R, SQLException>(){

                        @Override
                        public R invoke(D database, S statement) throws SQLException {
                            ArrayList<Object> parameterList = new ArrayList<Object>(Arrays.asList(parameters));
                            parameterList.set(1, proxy.getObject(database));
                            return Methods.invoke(method, AbstractPreparedStatementInvocationHandler.this.getExceptionFactory(), statement, parameterList.toArray());
                        }
                    };
                }
                SerialClob serialClob = new SerialClob(clob);
                parameters[1] = type.equals(Clob.class) ? serialClob : ProxyFactory.createProxy(type, new SimpleInvocationHandler(serialClob));
            }
        }
        return super.getInvoker(statement, method, parameters);
    }

    @Override
    protected boolean isBatchMethod(Method method) {
        return method.equals(addBatchMethod) || method.equals(clearParametersMethod) || this.isParameterSetMethod(method) || super.isBatchMethod(method);
    }

    private boolean isParameterSetMethod(Method method) {
        Class<?>[] types = method.getParameterTypes();
        return this.setMethodSet.contains(method) && types.length > 0 && this.isIndexType(types[0]);
    }

    protected boolean isIndexType(Class<?> type) {
        return type.equals(Integer.TYPE);
    }
}

