/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DatabaseProperties;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.QualifiedName;
import net.sf.hajdbc.TableProperties;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.lock.LockManager;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.sql.ChildInvocationHandler;
import net.sf.hajdbc.sql.FileSupport;
import net.sf.hajdbc.sql.InvocationHandlerFactory;
import net.sf.hajdbc.sql.LockingInvocationStrategy;
import net.sf.hajdbc.sql.ResultSetInvocationHandlerFactory;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.sql.TransactionContext;
import net.sf.hajdbc.util.Resources;
import net.sf.hajdbc.util.reflect.Methods;

public abstract class AbstractStatementInvocationHandler<Z, D extends Database<Z>, S extends Statement>
extends ChildInvocationHandler<Z, D, Connection, S, SQLException> {
    private static final Set<Method> driverReadMethodSet = Methods.findMethods(Statement.class, "getFetchDirection", "getFetchSize", "getGeneratedKeys", "getMaxFieldSize", "getMaxRows", "getQueryTimeout", "getResultSetConcurrency", "getResultSetHoldability", "getResultSetType", "getUpdateCount", "getWarnings", "isClosed", "isPoolable");
    private static final Set<Method> driverWriteMethodSet = Methods.findMethods(Statement.class, "clearWarnings", "setCursorName", "setEscapeProcessing", "setFetchDirection", "setFetchSize", "setMaxFieldSize", "setMaxRows", "setPoolable", "setQueryTimeout");
    private static final Set<Method> executeMethodSet = Methods.findMethods(Statement.class, "execute(Update)?");
    private static final Method getConnectionMethod = Methods.getMethod(Statement.class, "getConnection", new Class[0]);
    private static final Method executeQueryMethod = Methods.getMethod(Statement.class, "executeQuery", String.class);
    private static final Method clearBatchMethod = Methods.getMethod(Statement.class, "clearBatch", new Class[0]);
    private static final Method executeBatchMethod = Methods.getMethod(Statement.class, "executeBatch", new Class[0]);
    private static final Method getMoreResultsMethod = Methods.getMethod(Statement.class, "getMoreResults", Integer.TYPE);
    private static final Method getResultSetMethod = Methods.getMethod(Statement.class, "getResultSet", new Class[0]);
    private static final Method addBatchMethod = Methods.getMethod(Statement.class, "addBatch", String.class);
    private static final Method closeMethod = Methods.getMethod(Statement.class, "close", new Class[0]);
    protected TransactionContext<Z, D> transactionContext;
    protected FileSupport<SQLException> fileSupport;
    private List<Invoker<Z, D, S, ?, SQLException>> batchInvokerList = new LinkedList();
    private List<String> sqlList = new LinkedList<String>();

    protected AbstractStatementInvocationHandler(Connection connection, SQLProxy<Z, D, Connection, SQLException> proxy, Invoker<Z, D, Connection, S, SQLException> invoker, Class<S> statementClass, Map<D, S> statementMap, TransactionContext<Z, D> transactionContext, FileSupport<SQLException> fileSupport) {
        super(connection, proxy, invoker, statementClass, SQLException.class, statementMap);
        this.transactionContext = transactionContext;
        this.fileSupport = fileSupport;
    }

    @Override
    protected Method getParentMethod() {
        return getConnectionMethod;
    }

    @Override
    protected InvocationHandlerFactory<Z, D, S, ?, SQLException> getInvocationHandlerFactory(S object, Method method, Object[] parameters) throws SQLException {
        if (method.equals(executeQueryMethod) || method.equals(getResultSetMethod)) {
            return new ResultSetInvocationHandlerFactory(this.transactionContext, this.fileSupport);
        }
        return super.getInvocationHandlerFactory(object, method, parameters);
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(S statement, Method method, Object[] parameters) throws SQLException {
        if (driverReadMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ANY;
        }
        if (driverWriteMethodSet.contains(method) || method.equals(closeMethod)) {
            return InvocationStrategyEnum.INVOKE_ON_EXISTING;
        }
        if (executeMethodSet.contains(method)) {
            List<Lock> lockList = this.extractLocks((String)parameters[0]);
            return this.transactionContext.start(new LockingInvocationStrategy(InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL, lockList), (Connection)this.getParent());
        }
        if (method.equals(executeQueryMethod)) {
            boolean lockingSelect;
            String sql = (String)parameters[0];
            List<Lock> lockList = this.extractLocks(sql);
            int concurrency = statement.getResultSetConcurrency();
            boolean bl = lockingSelect = this.isLockingSelect(sql) || statement.getConnection().getTransactionIsolation() >= 4;
            if (lockList.isEmpty() && concurrency == 1007 && !lockingSelect) {
                return InvocationStrategyEnum.INVOKE_ON_NEXT;
            }
            LockingInvocationStrategy strategy = new LockingInvocationStrategy(InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL, lockList);
            return lockingSelect ? this.transactionContext.start(strategy, (Connection)this.getParent()) : strategy;
        }
        if (method.equals(executeBatchMethod)) {
            List<Lock> lockList = this.extractLocks(this.sqlList);
            return this.transactionContext.start(new LockingInvocationStrategy(InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL, lockList), (Connection)this.getParent());
        }
        if (method.equals(getMoreResultsMethod) && parameters[0].equals(2)) {
            return InvocationStrategyEnum.INVOKE_ON_EXISTING;
        }
        if (method.equals(getResultSetMethod)) {
            if (statement.getResultSetConcurrency() == 1007) {
                return InvocationStrategyEnum.INVOKE_ON_EXISTING;
            }
            return InvocationStrategyEnum.INVOKE_ON_ALL;
        }
        return super.getInvocationStrategy(statement, method, parameters);
    }

    @Override
    protected boolean isSQLMethod(Method method) {
        return method.equals(addBatchMethod) || method.equals(executeQueryMethod) || executeMethodSet.contains(method);
    }

    @Override
    protected void postInvoke(S statement, Method method, Object[] parameters) {
        if (method.equals(addBatchMethod)) {
            this.sqlList.add((String)parameters[0]);
        } else if (method.equals(clearBatchMethod) || method.equals(executeBatchMethod)) {
            this.sqlList.clear();
        } else if (method.equals(closeMethod)) {
            Resources.close(this.fileSupport);
            this.getParentProxy().removeChild(this);
        }
    }

    protected boolean isLockingSelect(String sql) throws SQLException {
        Connection connection = (Connection)this.getParent();
        return connection.getTransactionIsolation() >= 4 || this.getDatabaseProperties().supportsSelectForUpdate() && this.getDatabaseCluster().getDialect().isSelectForUpdate(sql);
    }

    protected List<Lock> extractLocks(String sql) throws SQLException {
        return this.extractLocks(Collections.singletonList(sql));
    }

    private List<Lock> extractLocks(List<String> sqlList) throws SQLException {
        TreeSet<String> identifierSet = new TreeSet<String>();
        DatabaseCluster cluster = this.getDatabaseCluster();
        for (String sql : sqlList) {
            String table;
            String sequence;
            Object support;
            if (cluster.isSequenceDetectionEnabled() && (support = cluster.getDialect().getSequenceSupport()) != null && (sequence = support.parseSequence(sql)) != null) {
                identifierSet.add(sequence);
            }
            if (!cluster.isIdentityColumnDetectionEnabled() || (support = cluster.getDialect().getIdentityColumnSupport()) == null || (table = support.parseInsertTable(sql)) == null) continue;
            TableProperties tableProperties = this.getDatabaseProperties().findTable(table);
            if (tableProperties == null) {
                throw new SQLException(Messages.SCHEMA_LOOKUP_FAILED.getMessage(table, cluster, cluster.getDialect().getClass().getName() + ".getDefaultSchemas()"));
            }
            if (tableProperties.getIdentityColumns().isEmpty()) continue;
            identifierSet.add(((QualifiedName)tableProperties.getName()).getDMLName());
        }
        ArrayList<Lock> lockList = new ArrayList<Lock>(identifierSet.size());
        if (!identifierSet.isEmpty()) {
            LockManager lockManager = cluster.getLockManager();
            for (String identifier : identifierSet) {
                lockList.add(lockManager.writeLock(identifier));
            }
        }
        return lockList;
    }

    protected DatabaseProperties getDatabaseProperties() throws SQLException {
        DatabaseCluster cluster = this.getDatabaseCluster();
        return cluster.getDatabaseMetaDataCache().getDatabaseProperties(cluster.getBalancer().next(), (Connection)this.getParent());
    }

    @Override
    protected void close(Connection connection, S statement) throws SQLException {
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void record(Invoker<Z, D, S, ?, SQLException> invoker, Method method, Object[] parameters) {
        if (this.isBatchMethod(method)) {
            List<Invoker<Z, D, S, ?, SQLException>> list = this.batchInvokerList;
            synchronized (list) {
                this.logger.log(Level.TRACE, "Recording batch method: {0}", invoker);
                this.batchInvokerList.add(invoker);
            }
        } else if (this.isEndBatchMethod(method)) {
            List<Invoker<Z, D, S, ?, SQLException>> list = this.batchInvokerList;
            synchronized (list) {
                this.logger.log(Level.TRACE, "Clearing recorded batch methods", new Object[0]);
                this.batchInvokerList.clear();
            }
        } else {
            super.record(invoker, method, parameters);
        }
    }

    @Override
    protected boolean isRecordable(Method method) {
        return driverWriteMethodSet.contains(method);
    }

    protected boolean isBatchMethod(Method method) {
        return method.equals(addBatchMethod);
    }

    protected boolean isEndBatchMethod(Method method) {
        return method.equals(clearBatchMethod) || method.equals(executeBatchMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replay(D database, S statement) throws SQLException {
        super.replay(database, statement);
        List<Invoker<Z, D, S, ?, SQLException>> list = this.batchInvokerList;
        synchronized (list) {
            for (Invoker<Z, D, S, ?, SQLException> invoker : this.batchInvokerList) {
                this.logger.log(Level.TRACE, "Replaying against database {0}: {1}.{2}", database, statement.getClass().getName(), invoker);
                invoker.invoke(database, statement);
            }
        }
    }
}

