/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.AbstractPreparedStatementInvocationHandler;
import net.sf.hajdbc.sql.FileSupport;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.sql.TransactionContext;
import net.sf.hajdbc.util.reflect.Methods;

public class CallableStatementInvocationHandler<Z, D extends Database<Z>>
extends AbstractPreparedStatementInvocationHandler<Z, D, CallableStatement> {
    private static final Set<Method> registerOutParameterMethodSet = Methods.findMethods(CallableStatement.class, "registerOutParameter");
    private static final Set<Method> setMethodSet = Methods.findMethods(CallableStatement.class, "set\\w+");
    private static final Set<Method> driverReadMethodSet = Methods.findMethods(CallableStatement.class, "get\\w+", "wasNull");

    public CallableStatementInvocationHandler(Connection connection, SQLProxy<Z, D, Connection, SQLException> proxy, Invoker<Z, D, Connection, CallableStatement, SQLException> invoker, Map<D, CallableStatement> statementMap, TransactionContext<Z, D> transactionContext, FileSupport<SQLException> fileSupport) {
        super(connection, proxy, invoker, CallableStatement.class, statementMap, transactionContext, fileSupport, setMethodSet);
        driverReadMethodSet.removeAll(Methods.findMethods(PreparedStatement.class, "get\\w+"));
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(CallableStatement statement, Method method, Object[] parameters) throws SQLException {
        if (registerOutParameterMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_EXISTING;
        }
        if (driverReadMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ANY;
        }
        return super.getInvocationStrategy(statement, method, parameters);
    }

    @Override
    protected boolean isBatchMethod(Method method) {
        return registerOutParameterMethodSet.contains(method) || super.isBatchMethod(method);
    }

    @Override
    protected boolean isIndexType(Class<?> type) {
        return super.isIndexType(type) || type.equals(String.class);
    }
}

