/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.naming.Referenceable;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DatabaseClusterConfiguration;
import net.sf.hajdbc.DatabaseClusterConfigurationFactory;
import net.sf.hajdbc.DatabaseClusterFactory;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.sql.CommonDataSourceInvocationHandlerFactory;
import net.sf.hajdbc.sql.DatabaseClusterFactoryImpl;
import net.sf.hajdbc.util.concurrent.LifecycleRegistry;
import net.sf.hajdbc.util.concurrent.ReferenceRegistryStoreFactory;
import net.sf.hajdbc.util.concurrent.Registry;
import net.sf.hajdbc.util.reflect.ProxyFactory;
import net.sf.hajdbc.xml.XMLDatabaseClusterConfigurationFactory;

public abstract class CommonDataSource<Z extends javax.sql.CommonDataSource, D extends Database<Z>>
implements Referenceable,
javax.sql.CommonDataSource,
Registry.Factory<Void, DatabaseCluster<Z, D>, Void, SQLException> {
    private final CommonDataSourceInvocationHandlerFactory<Z, D> handlerFactory;
    private final Class<? extends DatabaseClusterConfiguration<Z, D>> configurationClass;
    private final Registry<Void, DatabaseCluster<Z, D>, Void, SQLException> registry = new LifecycleRegistry<Void, DatabaseCluster<Z, D>, Void, SQLException>(this, new ReferenceRegistryStoreFactory(), ExceptionType.getExceptionFactory(SQLException.class));
    private volatile long timeout = 10L;
    private volatile TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private volatile String cluster;
    private volatile String config;
    private volatile DatabaseClusterFactory<Z, D> factory = new DatabaseClusterFactoryImpl();
    private volatile DatabaseClusterConfigurationFactory<Z, D> configurationFactory;

    protected CommonDataSource(CommonDataSourceInvocationHandlerFactory<Z, D> handlerFactory, Class<? extends DatabaseClusterConfiguration<Z, D>> configurationClass) {
        this.handlerFactory = handlerFactory;
        this.configurationClass = configurationClass;
    }

    public void stop() throws SQLException {
        this.registry.remove(null);
    }

    @Override
    public DatabaseCluster<Z, D> create(Void key, Void context) throws SQLException {
        XMLDatabaseClusterConfigurationFactory factory = this.configurationFactory != null ? this.configurationFactory : new XMLDatabaseClusterConfigurationFactory(this.configurationClass, this.cluster, this.config);
        return this.factory.createDatabaseCluster(this.cluster, factory);
    }

    public Z getProxy() throws SQLException {
        return (Z)((javax.sql.CommonDataSource)ProxyFactory.createProxy(this.handlerFactory.getTargetClass(), this.handlerFactory.createInvocationHandler(this.registry.get(null, null))));
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public DatabaseClusterConfigurationFactory<Z, D> getConfigurationFactory() {
        return this.configurationFactory;
    }

    public void setConfigurationFactory(DatabaseClusterConfigurationFactory<Z, D> configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    public DatabaseClusterFactory<Z, D> getFactory() {
        return this.factory;
    }

    public void setFactory(DatabaseClusterFactory<Z, D> clusterFactory) {
        this.factory = clusterFactory;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public void setTimeoutUnit(TimeUnit timeoutUnit) {
        this.timeoutUnit = timeoutUnit;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            return this.getProxy().getParentLogger();
        }
        catch (SQLFeatureNotSupportedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SQLFeatureNotSupportedException(e.getMessage(), e.getSQLState(), e.getErrorCode(), e.getCause());
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getProxy().getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getProxy().getLogWriter();
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.getProxy().setLoginTimeout(timeout);
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        this.getProxy().setLogWriter(writer);
    }
}

