/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.CommonDataSource;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.management.Description;
import net.sf.hajdbc.management.ManagedAttribute;
import net.sf.hajdbc.sql.AbstractDatabase;

public abstract class CommonDataSourceDatabase<Z extends CommonDataSource>
extends AbstractDatabase<Z> {
    private final Class<Z> targetClass;

    protected CommonDataSourceDatabase(Class<Z> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    @ManagedAttribute
    @Description(value="The JNDI name to which this DataSource is bound, or the class name of the DataSource implementation")
    public void setLocation(String name) {
        super.setLocation(name);
    }

    @Override
    public Z createConnectionSource() {
        try {
            Class<?> dataSourceClass = this.getClass().getClassLoader().loadClass(this.getLocation());
            return this.createDataSource(dataSourceClass.asSubclass(this.targetClass));
        }
        catch (ClassNotFoundException e) {
            return this.createDataSource();
        }
    }

    private Z createDataSource() {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        String name = this.getLocation();
        try {
            InitialContext context = new InitialContext(properties);
            return (Z)((CommonDataSource)this.targetClass.cast(context.lookup(name)));
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(Messages.JNDI_LOOKUP_FAILED.getMessage(name), e);
        }
    }

    private Z createDataSource(Class<? extends Z> dataSourceClass) {
        Map<String, String> properties = this.getProperties();
        try {
            CommonDataSource dataSource = (CommonDataSource)dataSourceClass.newInstance();
            for (PropertyDescriptor descriptor : Introspector.getBeanInfo(dataSourceClass).getPropertyDescriptors()) {
                String value = properties.get(descriptor.getName());
                if (value == null) continue;
                PropertyEditor editor = PropertyEditorManager.findEditor(descriptor.getPropertyType());
                editor.setAsText(value);
                descriptor.getWriteMethod().invoke((Object)dataSource, editor.getValue());
            }
            return (Z)dataSource;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getTargetException().toString(), e);
        }
    }
}

