/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.CommonDataSource;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseClusterConfigurationFactory;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.sql.CommonDataSourceInvocationHandlerFactory;
import net.sf.hajdbc.sql.DatabaseClusterImpl;
import net.sf.hajdbc.util.Objects;
import net.sf.hajdbc.util.reflect.ProxyFactory;

public abstract class CommonDataSourceFactory<Z extends CommonDataSource, D extends Database<Z>>
implements ObjectFactory,
CommonDataSourceInvocationHandlerFactory<Z, D> {
    private final Class<Z> targetClass;

    protected CommonDataSourceFactory(Class<Z> targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> environment) throws Exception {
        if (object == null || !(object instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)object;
        String className = reference.getClassName();
        if (className == null || !className.equals(this.targetClass.getName())) {
            return null;
        }
        RefAddr idAddr = reference.get("cluster");
        if (idAddr == null) {
            return null;
        }
        Object idAddrContent = idAddr.getContent();
        if (idAddrContent == null || !(idAddrContent instanceof String)) {
            return null;
        }
        String id = (String)idAddrContent;
        RefAddr configAddr = reference.get("config");
        if (configAddr == null) {
            return null;
        }
        Object configAddrContent = configAddr.getContent();
        if (configAddrContent == null || !(configAddrContent instanceof byte[])) {
            return null;
        }
        byte[] config = (byte[])configAddr.getContent();
        DatabaseClusterConfigurationFactory factory = (DatabaseClusterConfigurationFactory)Objects.deserialize(config);
        DatabaseClusterImpl cluster = new DatabaseClusterImpl(id, factory.createConfiguration(), factory);
        try {
            cluster.start();
        }
        catch (Exception e) {
            cluster.stop();
            throw ExceptionType.getExceptionFactory(SQLException.class).createException(e);
        }
        return ProxyFactory.createProxy(this.targetClass, this.createInvocationHandler(cluster));
    }

    @Override
    public Class<Z> getTargetClass() {
        return this.targetClass;
    }
}

