/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Set;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.sql.CommonDataSource;
import net.sf.hajdbc.sql.CommonDataSourceDatabase;
import net.sf.hajdbc.sql.RootInvocationHandler;
import net.sf.hajdbc.util.reflect.Methods;

public class CommonDataSourceInvocationHandler<Z extends javax.sql.CommonDataSource, D extends CommonDataSourceDatabase<Z>>
extends RootInvocationHandler<Z, D, SQLException> {
    private static final Set<Method> getMethodSet = Methods.findMethods(CommonDataSource.class, "get\\w+");
    private static final Set<Method> setMethodSet = Methods.findMethods(CommonDataSource.class, "set\\w+");

    protected CommonDataSourceInvocationHandler(DatabaseCluster<Z, D> databaseCluster, Class<Z> proxyClass) {
        super(databaseCluster, proxyClass, SQLException.class);
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(Z dataSource, Method method, Object[] parameters) throws SQLException {
        if (getMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ANY;
        }
        if (setMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_EXISTING;
        }
        return super.getInvocationStrategy(dataSource, method, parameters);
    }

    @Override
    protected boolean isRecordable(Method method) {
        return setMethodSet.contains(method);
    }
}

