/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import javax.naming.BinaryRefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseClusterConfiguration;
import net.sf.hajdbc.DatabaseClusterConfigurationFactory;
import net.sf.hajdbc.util.Objects;
import net.sf.hajdbc.xml.XMLDatabaseClusterConfigurationFactory;

public abstract class CommonDataSourceReference<Z>
extends Reference {
    private static final long serialVersionUID = 1408239702660701511L;
    protected static final String CLUSTER = "cluster";
    protected static final String CONFIG = "config";

    protected <D extends Database<Z>> CommonDataSourceReference(Class<Z> targetClass, Class<? extends ObjectFactory> factoryClass, String cluster, Class<? extends DatabaseClusterConfiguration<Z, D>> configurationClass, String config) {
        this(targetClass, factoryClass, cluster, new XMLDatabaseClusterConfigurationFactory(configurationClass, cluster, config));
    }

    protected <D extends Database<Z>> CommonDataSourceReference(Class<Z> targetClass, Class<? extends ObjectFactory> factoryClass, String cluster, DatabaseClusterConfigurationFactory<Z, D> factory) {
        super(targetClass.getName(), factoryClass.getName(), null);
        if (cluster == null) {
            throw new IllegalArgumentException();
        }
        this.add(new StringRefAddr(CLUSTER, cluster));
        this.add(new BinaryRefAddr(CONFIG, Objects.serialize(factory)));
    }
}

