/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.durability.Durability;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.BlobInvocationHandlerFactory;
import net.sf.hajdbc.sql.CallableStatementInvocationHandlerFactory;
import net.sf.hajdbc.sql.ChildInvocationHandler;
import net.sf.hajdbc.sql.ClobInvocationHandlerFactory;
import net.sf.hajdbc.sql.DatabaseMetaDataInvocationHandlerFactory;
import net.sf.hajdbc.sql.DurabilityPhaseRegistry;
import net.sf.hajdbc.sql.InvocationHandlerFactory;
import net.sf.hajdbc.sql.NClobInvocationHandlerFactory;
import net.sf.hajdbc.sql.PreparedStatementInvocationHandlerFactory;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.sql.SQLXMLInvocationHandlerFactory;
import net.sf.hajdbc.sql.SavepointInvocationHandlerFactory;
import net.sf.hajdbc.sql.StatementInvocationHandlerFactory;
import net.sf.hajdbc.sql.TransactionContext;
import net.sf.hajdbc.util.StaticRegistry;
import net.sf.hajdbc.util.reflect.Methods;

public class ConnectionInvocationHandler<Z, D extends Database<Z>, P>
extends ChildInvocationHandler<Z, D, P, Connection, SQLException> {
    private static final Set<Method> driverReadMethodSet = Methods.findMethods(Connection.class, "create(ArrayOf|Struct)", "getAutoCommit", "getCatalog", "getClientInfo", "getHoldability", "getNetworkTimeout", "getSchema", "getTypeMap", "getWarnings", "isClosed", "isCloseOnCompletion", "isReadOnly", "nativeSQL");
    private static final Set<Method> databaseReadMethodSet = Methods.findMethods(Connection.class, "getTransactionIsolation", "isValid");
    private static final Set<Method> driverWriterMethodSet = Methods.findMethods(Connection.class, "abort", "clearWarnings", "closeOnCompletion", "setClientInfo", "setHoldability", "setNetworkTimeout", "setSchema", "setTypeMap");
    private static final Set<Method> createStatementMethodSet = Methods.findMethods(Connection.class, "createStatement");
    private static final Set<Method> prepareStatementMethodSet = Methods.findMethods(Connection.class, "prepareStatement");
    private static final Set<Method> prepareCallMethodSet = Methods.findMethods(Connection.class, "prepareCall");
    private static final Set<Method> setSavepointMethodSet = Methods.findMethods(Connection.class, "setSavepoint");
    private static final Method setAutoCommitMethod = Methods.getMethod(Connection.class, "setAutoCommit", Boolean.TYPE);
    private static final Method commitMethod = Methods.getMethod(Connection.class, "commit", new Class[0]);
    private static final Method rollbackMethod = Methods.getMethod(Connection.class, "rollback", new Class[0]);
    private static final Method getMetaDataMethod = Methods.getMethod(Connection.class, "getMetaData", new Class[0]);
    private static final Method releaseSavepointMethod = Methods.getMethod(Connection.class, "releaseSavepoint", Savepoint.class);
    private static final Method rollbackSavepointMethod = Methods.getMethod(Connection.class, "rollback", Savepoint.class);
    private static final Method closeMethod = Methods.getMethod(Connection.class, "close", new Class[0]);
    private static final Method createBlobMethod = Methods.getMethod(Connection.class, "createBlob", new Class[0]);
    private static final Method createClobMethod = Methods.getMethod(Connection.class, "createClob", new Class[0]);
    private static final Method createNClobMethod = Methods.getMethod(Connection.class, "createNClob", new Class[0]);
    private static final Method createSQLXMLMethod = Methods.getMethod(Connection.class, "createSQLXML", new Class[0]);
    private static final Set<Method> endTransactionMethodSet = new HashSet<Method>(Arrays.asList(commitMethod, rollbackMethod, setAutoCommitMethod));
    private static final Set<Method> createLocatorMethodSet = new HashSet<Method>(Arrays.asList(createBlobMethod, createClobMethod, createNClobMethod, createSQLXMLMethod));
    private static final StaticRegistry<Method, Durability.Phase> phaseRegistry = new DurabilityPhaseRegistry(Arrays.asList(commitMethod, setAutoCommitMethod), Arrays.asList(rollbackMethod));
    private TransactionContext<Z, D> transactionContext;

    public ConnectionInvocationHandler(P proxy, SQLProxy<Z, D, P, SQLException> handler, Invoker<Z, D, P, Connection, SQLException> invoker, Map<D, Connection> connectionMap, TransactionContext<Z, D> transactionContext) {
        super(proxy, handler, invoker, Connection.class, SQLException.class, connectionMap);
        this.transactionContext = transactionContext;
    }

    @Override
    protected InvocationHandlerFactory<Z, D, Connection, ?, SQLException> getInvocationHandlerFactory(Connection connection, Method method, Object[] parameters) {
        if (createStatementMethodSet.contains(method)) {
            return new StatementInvocationHandlerFactory<Z, D>(this.transactionContext);
        }
        if (prepareStatementMethodSet.contains(method)) {
            return new PreparedStatementInvocationHandlerFactory<Z, D>(this.transactionContext, (String)parameters[0]);
        }
        if (prepareCallMethodSet.contains(method)) {
            return new CallableStatementInvocationHandlerFactory<Z, D>(this.transactionContext);
        }
        if (setSavepointMethodSet.contains(method)) {
            return new SavepointInvocationHandlerFactory();
        }
        if (method.equals(getMetaDataMethod)) {
            return new DatabaseMetaDataInvocationHandlerFactory();
        }
        if (method.equals(createBlobMethod)) {
            return new BlobInvocationHandlerFactory(connection);
        }
        if (method.equals(createClobMethod)) {
            return new ClobInvocationHandlerFactory(connection);
        }
        if (method.equals(createNClobMethod)) {
            return new NClobInvocationHandlerFactory(connection);
        }
        if (method.equals(createSQLXMLMethod)) {
            return new SQLXMLInvocationHandlerFactory(connection);
        }
        return null;
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(Connection connection, Method method, Object[] parameters) throws SQLException {
        if (driverReadMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ANY;
        }
        if (databaseReadMethodSet.contains(method) || method.equals(getMetaDataMethod)) {
            return InvocationStrategyEnum.INVOKE_ON_NEXT;
        }
        if (driverWriterMethodSet.contains(method) || method.equals(closeMethod) || createStatementMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_EXISTING;
        }
        if (prepareStatementMethodSet.contains(method) || prepareCallMethodSet.contains(method) || createLocatorMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ALL;
        }
        if (endTransactionMethodSet.contains(method)) {
            return this.transactionContext.end(InvocationStrategyEnum.END_TRANSACTION_INVOKE_ON_ALL, phaseRegistry.get(method));
        }
        if (method.equals(rollbackSavepointMethod) || method.equals(releaseSavepointMethod)) {
            return InvocationStrategyEnum.END_TRANSACTION_INVOKE_ON_ALL;
        }
        if (setSavepointMethodSet.contains(method)) {
            return InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL;
        }
        return super.getInvocationStrategy(connection, method, parameters);
    }

    @Override
    protected <R> Invoker<Z, D, Connection, R, SQLException> getInvoker(Connection connection, Method method, Object[] parameters) throws SQLException {
        if (method.equals(releaseSavepointMethod)) {
            final SQLProxy proxy = this.getInvocationHandler((Savepoint)parameters[0]);
            return new Invoker<Z, D, Connection, R, SQLException>(){

                @Override
                public R invoke(D database, Connection connection) throws SQLException {
                    connection.releaseSavepoint((Savepoint)proxy.getObject(database));
                    return null;
                }
            };
        }
        if (method.equals(rollbackSavepointMethod)) {
            final SQLProxy proxy = this.getInvocationHandler((Savepoint)parameters[0]);
            return new Invoker<Z, D, Connection, R, SQLException>(){

                @Override
                public R invoke(D database, Connection connection) throws SQLException {
                    connection.rollback((Savepoint)proxy.getObject(database));
                    return null;
                }
            };
        }
        Invoker invoker = super.getInvoker(connection, method, parameters);
        if (endTransactionMethodSet.contains(method)) {
            return this.transactionContext.end(invoker, phaseRegistry.get(method));
        }
        return invoker;
    }

    @Override
    protected boolean isSQLMethod(Method method) {
        return prepareStatementMethodSet.contains(method);
    }

    @Override
    protected boolean isRecordable(Method method) {
        return driverWriterMethodSet.contains(method) || method.equals(setAutoCommitMethod);
    }

    @Override
    protected void postInvoke(Connection object, Method method, Object[] parameters) {
        if (method.equals(closeMethod)) {
            this.transactionContext.close();
            this.getParentProxy().removeChild(this);
        } else if (method.equals(releaseSavepointMethod)) {
            SQLProxy proxy = (SQLProxy)((Object)Proxy.getInvocationHandler(parameters[0]));
            this.removeChild(proxy);
        }
    }

    @Override
    protected void close(P parent, Connection connection) throws SQLException {
        connection.close();
    }
}

