/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.DataSource;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.sql.CommonDataSourceInvocationHandler;
import net.sf.hajdbc.sql.ConnectionInvocationHandlerFactory;
import net.sf.hajdbc.sql.DataSourceDatabase;
import net.sf.hajdbc.sql.InvocationHandlerFactory;
import net.sf.hajdbc.sql.LocalTransactionContext;
import net.sf.hajdbc.util.reflect.Methods;

public class DataSourceInvocationHandler
extends CommonDataSourceInvocationHandler<DataSource, DataSourceDatabase> {
    private static final Set<Method> getConnectionMethods = Methods.findMethods(DataSource.class, "getConnection");

    public DataSourceInvocationHandler(DatabaseCluster<DataSource, DataSourceDatabase> databaseCluster) {
        super(databaseCluster, DataSource.class);
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(DataSource dataSource, Method method, Object[] parameters) throws SQLException {
        if (getConnectionMethods.contains(method)) {
            return InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL;
        }
        return super.getInvocationStrategy(dataSource, method, parameters);
    }

    @Override
    protected InvocationHandlerFactory<DataSource, DataSourceDatabase, DataSource, ?, SQLException> getInvocationHandlerFactory(DataSource object, Method method, Object[] parameters) throws SQLException {
        if (getConnectionMethods.contains(method)) {
            LocalTransactionContext context = new LocalTransactionContext(this.getDatabaseCluster());
            return new ConnectionInvocationHandlerFactory<DataSource, DataSourceDatabase, DataSource>(context);
        }
        return null;
    }
}

