/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import javax.management.JMException;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DatabaseClusterConfiguration;
import net.sf.hajdbc.DatabaseClusterConfigurationListener;
import net.sf.hajdbc.DatabaseClusterListener;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.SynchronizationListener;
import net.sf.hajdbc.SynchronizationStrategy;
import net.sf.hajdbc.TransactionMode;
import net.sf.hajdbc.Version;
import net.sf.hajdbc.balancer.Balancer;
import net.sf.hajdbc.cache.DatabaseMetaDataCache;
import net.sf.hajdbc.codec.Decoder;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.distributed.CommandDispatcherFactory;
import net.sf.hajdbc.durability.Durability;
import net.sf.hajdbc.lock.LockManager;
import net.sf.hajdbc.lock.distributed.DistributedLockManager;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.management.Description;
import net.sf.hajdbc.management.MBean;
import net.sf.hajdbc.management.MBeanRegistrar;
import net.sf.hajdbc.management.ManagedAttribute;
import net.sf.hajdbc.management.ManagedOperation;
import net.sf.hajdbc.state.DatabaseEvent;
import net.sf.hajdbc.state.StateManager;
import net.sf.hajdbc.state.distributed.DistributedStateManager;
import net.sf.hajdbc.sync.SynchronizationContextImpl;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;
import net.sf.hajdbc.util.Resources;
import net.sf.hajdbc.util.concurrent.cron.CronExpression;
import net.sf.hajdbc.util.concurrent.cron.CronThreadPoolExecutor;

@MBean
public class DatabaseClusterImpl<Z, D extends Database<Z>>
implements DatabaseCluster<Z, D> {
    static final Logger logger = LoggerFactory.getLogger(DatabaseClusterImpl.class);
    private final String id;
    final DatabaseClusterConfiguration<Z, D> configuration;
    private Balancer<Z, D> balancer;
    private Dialect dialect;
    private Durability<Z, D> durability;
    private DatabaseMetaDataCache<Z, D> databaseMetaDataCache;
    private ExecutorService executor;
    private Decoder decoder;
    private CronThreadPoolExecutor cronExecutor;
    private LockManager lockManager;
    private StateManager stateManager;
    private boolean active = false;
    private final List<DatabaseClusterConfigurationListener<Z, D>> configurationListeners = new CopyOnWriteArrayList<DatabaseClusterConfigurationListener<Z, D>>();
    private final List<DatabaseClusterListener> clusterListeners = new CopyOnWriteArrayList<DatabaseClusterListener>();
    private final List<SynchronizationListener> synchronizationListeners = new CopyOnWriteArrayList<SynchronizationListener>();

    public DatabaseClusterImpl(String id, DatabaseClusterConfiguration<Z, D> configuration, DatabaseClusterConfigurationListener<Z, D> listener) {
        this.id = id;
        this.configuration = configuration;
        if (listener != null) {
            this.configurationListeners.add(listener);
        }
    }

    @ManagedOperation
    public void deactivate(String databaseId) {
        this.deactivate(this.getDatabase(databaseId), this.stateManager);
    }

    @ManagedOperation
    public void activate(String databaseId) {
        this.activate(databaseId, this.configuration.getDefaultSynchronizationStrategy());
    }

    @ManagedOperation
    public void activate(String databaseId, String strategyId) {
        SynchronizationStrategy strategy = this.configuration.getSynchronizationStrategyMap().get(strategyId);
        if (strategy == null) {
            throw new IllegalArgumentException(Messages.INVALID_SYNC_STRATEGY.getMessage(this, strategyId));
        }
        try {
            if (this.activate(this.getDatabase(databaseId), strategy)) {
                logger.log(Level.INFO, Messages.DATABASE_ACTIVATED.getMessage(this, databaseId), new Object[0]);
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARN, e, Messages.DATABASE_ACTIVATE_FAILED.getMessage(this, databaseId), new Object[0]);
            for (SQLException exception = e.getNextException(); exception != null; exception = exception.getNextException()) {
                logger.log(Level.ERROR, exception);
            }
            throw new IllegalStateException(e.toString());
        }
        catch (InterruptedException e) {
            logger.log(Level.WARN, e);
            Thread.currentThread().interrupt();
        }
    }

    @ManagedOperation
    public boolean isAlive(String databaseId) {
        return this.isAlive(this.getDatabase(databaseId));
    }

    @ManagedAttribute
    public Set<String> getActiveDatabases() {
        TreeSet<String> databases = new TreeSet<String>();
        for (Database database : this.balancer) {
            databases.add(database.getId());
        }
        return databases;
    }

    @ManagedAttribute
    public Set<String> getInactiveDatabases() {
        TreeSet<String> databases = new TreeSet<String>(this.configuration.getDatabaseMap().keySet());
        for (Database database : this.balancer) {
            databases.remove(database.getId());
        }
        return databases;
    }

    @ManagedAttribute
    public String getVersion() {
        return Version.getVersion();
    }

    @ManagedOperation
    public void add(String databaseId) throws JMException {
        D database = this.configuration.getDatabaseFactory().createDatabase(databaseId);
        if (this.configuration.getDatabaseMap().putIfAbsent(databaseId, database) != null) {
            throw new IllegalArgumentException(Messages.DATABASE_ALREADY_EXISTS.getMessage(databaseId, this));
        }
        this.configuration.getMBeanRegistrar().register(this, database);
        for (DatabaseClusterConfigurationListener<Z, D> listener : this.configurationListeners) {
            listener.added(database, this.configuration);
        }
    }

    @ManagedOperation
    public void remove(String databaseId) {
        D database = this.getDatabase(databaseId);
        if (this.balancer.contains(database)) {
            throw new IllegalStateException(Messages.DATABASE_STILL_ACTIVE.getMessage(this, databaseId));
        }
        this.configuration.getMBeanRegistrar().unregister(this, database);
        this.configuration.getDatabaseMap().remove(databaseId);
        for (DatabaseClusterConfigurationListener<Z, D> listener : this.configurationListeners) {
            listener.removed(database, this.configuration);
        }
    }

    @Override
    @ManagedAttribute
    public String getId() {
        return this.id;
    }

    @Override
    @ManagedAttribute
    public boolean isActive() {
        return this.active;
    }

    @ManagedAttribute
    public Set<String> getSynchronizationStrategies() {
        return this.configuration.getSynchronizationStrategyMap().keySet();
    }

    @ManagedAttribute
    public String getDefaultSynchronizationStrategy() {
        return this.configuration.getDefaultSynchronizationStrategy();
    }

    @ManagedOperation
    @Description(value="Flushes this cluster's cache of database meta data")
    public void flushMetaDataCache() {
        try {
            this.databaseMetaDataCache.flush();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e.toString(), e);
        }
    }

    @Override
    @ManagedOperation
    public void addConfigurationListener(DatabaseClusterConfigurationListener<Z, D> listener) {
        this.configurationListeners.add(listener);
    }

    @Override
    @ManagedOperation
    public void addListener(DatabaseClusterListener listener) {
        this.clusterListeners.add(listener);
    }

    @Override
    @ManagedOperation
    public void addSynchronizationListener(SynchronizationListener listener) {
        this.synchronizationListeners.add(listener);
    }

    @Override
    @ManagedOperation
    public void removeConfigurationListener(DatabaseClusterConfigurationListener<Z, D> listener) {
        this.configurationListeners.remove(listener);
    }

    @Override
    @ManagedOperation
    public void removeListener(DatabaseClusterListener listener) {
        this.clusterListeners.remove(listener);
    }

    @Override
    @ManagedOperation
    public void removeSynchronizationListener(SynchronizationListener listener) {
        this.synchronizationListeners.remove(listener);
    }

    @Override
    public boolean activate(D database, StateManager manager) {
        boolean added = this.balancer.add(database);
        if (added) {
            database.setActive(true);
            if (database.isDirty()) {
                database.clean();
            }
            DatabaseEvent event = new DatabaseEvent((Database<?>)database);
            manager.activated(event);
            for (DatabaseClusterListener listener : this.clusterListeners) {
                listener.activated(event);
            }
        }
        return added;
    }

    @Override
    public boolean deactivate(D database, StateManager manager) {
        boolean removed = this.balancer.remove(database);
        if (removed) {
            database.setActive(false);
            DatabaseEvent event = new DatabaseEvent((Database<?>)database);
            manager.deactivated(event);
            for (DatabaseClusterListener listener : this.clusterListeners) {
                listener.deactivated(event);
            }
        }
        return removed;
    }

    @Override
    public Balancer<Z, D> getBalancer() {
        return this.balancer;
    }

    @Override
    public D getDatabase(String id) {
        Database database = (Database)this.configuration.getDatabaseMap().get(id);
        if (database == null) {
            throw new IllegalArgumentException(Messages.INVALID_DATABASE.getMessage(this, id));
        }
        return (D)database;
    }

    @Override
    public DatabaseMetaDataCache<Z, D> getDatabaseMetaDataCache() {
        return this.databaseMetaDataCache;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public Durability<Z, D> getDurability() {
        return this.durability;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public TransactionMode getTransactionMode() {
        return this.configuration.getTransactionMode();
    }

    @Override
    public StateManager getStateManager() {
        return this.stateManager;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.configuration.getThreadFactory();
    }

    @Override
    public Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public TransactionIdentifierFactory<? extends Object> getTransactionIdentifierFactory() {
        return this.configuration.getTransactionIdentifierFactory();
    }

    @Override
    public boolean isCurrentDateEvaluationEnabled() {
        return this.configuration.isCurrentDateEvaluationEnabled();
    }

    @Override
    public boolean isCurrentTimeEvaluationEnabled() {
        return this.configuration.isCurrentTimeEvaluationEnabled();
    }

    @Override
    public boolean isCurrentTimestampEvaluationEnabled() {
        return this.configuration.isCurrentTimestampEvaluationEnabled();
    }

    @Override
    public boolean isIdentityColumnDetectionEnabled() {
        return this.configuration.isIdentityColumnDetectionEnabled();
    }

    @Override
    public boolean isRandEvaluationEnabled() {
        return this.configuration.isRandEvaluationEnabled();
    }

    @Override
    public boolean isSequenceDetectionEnabled() {
        return this.configuration.isSequenceDetectionEnabled();
    }

    @Override
    public synchronized void start() throws Exception {
        MBeanRegistrar<Z, Database> registrar;
        if (this.active) {
            return;
        }
        this.decoder = this.configuration.getDecoderFactory().createDecoder(this.id);
        this.lockManager = this.configuration.getLockManagerFactory().createLockManager();
        this.stateManager = this.configuration.getStateManagerFactory().createStateManager(this);
        CommandDispatcherFactory dispatcherFactory = this.configuration.getDispatcherFactory();
        if (dispatcherFactory != null) {
            this.lockManager = new DistributedLockManager(this, dispatcherFactory);
            this.stateManager = new DistributedStateManager(this, dispatcherFactory);
        }
        this.balancer = this.configuration.getBalancerFactory().createBalancer(new TreeSet());
        this.dialect = this.configuration.getDialectFactory().createDialect();
        this.durability = this.configuration.getDurabilityFactory().createDurability(this);
        this.executor = this.configuration.getExecutorProvider().getExecutor(this.configuration.getThreadFactory());
        this.lockManager.start();
        this.stateManager.start();
        Set<String> databases = this.stateManager.getActiveDatabases();
        if (!databases.isEmpty()) {
            for (String databaseId : databases) {
                D database = this.getDatabase(databaseId);
                if (database != null) {
                    this.balancer.add(database);
                    continue;
                }
                logger.log(Level.WARN, Messages.DATABASE_IGNORED.getMessage(new Object[0]), this, databaseId);
            }
        } else {
            for (Database database : this.configuration.getDatabaseMap().values()) {
                if (!this.isAlive(database)) continue;
                this.activate(database, this.stateManager);
            }
        }
        this.durability.recover(this.stateManager.recover());
        this.databaseMetaDataCache = this.configuration.getDatabaseMetaDataCacheFactory().createCache(this);
        try {
            this.flushMetaDataCache();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        CronExpression failureDetectionExpression = this.configuration.getFailureDetectionExpression();
        CronExpression autoActivationExpression = this.configuration.getAutoActivationExpression();
        int threads = DatabaseClusterImpl.requiredThreads(failureDetectionExpression) + DatabaseClusterImpl.requiredThreads(autoActivationExpression);
        if (threads > 0) {
            this.cronExecutor = new CronThreadPoolExecutor(threads, this.configuration.getThreadFactory());
            if (failureDetectionExpression != null) {
                this.cronExecutor.schedule(new FailureDetectionTask(), failureDetectionExpression);
            }
            if (autoActivationExpression != null) {
                this.cronExecutor.schedule(new AutoActivationTask(), autoActivationExpression);
            }
        }
        if ((registrar = this.configuration.getMBeanRegistrar()) != null) {
            registrar.register(this);
            for (Database database : this.configuration.getDatabaseMap().values()) {
                registrar.register(this, database);
            }
        }
        this.active = true;
    }

    private static int requiredThreads(CronExpression expression) {
        return expression != null ? 1 : 0;
    }

    @Override
    public synchronized void stop() {
        this.active = false;
        MBeanRegistrar<Z, Database> registrar = this.configuration.getMBeanRegistrar();
        if (registrar != null) {
            registrar.unregister(this);
            for (Database database : this.configuration.getDatabaseMap().values()) {
                registrar.unregister(this, database);
            }
        }
        if (this.cronExecutor != null) {
            this.cronExecutor.shutdownNow();
        }
        if (this.stateManager != null) {
            this.stateManager.stop();
        }
        if (this.lockManager != null) {
            this.lockManager.stop();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.balancer != null) {
            this.balancer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAlive(D database) {
        boolean bl;
        Connection connection = database.connect(database.createConnectionSource(), database.decodePassword(this.decoder));
        try {
            bl = connection.isValid(0);
        }
        catch (Throwable throwable) {
            try {
                Resources.close(connection);
                throw throwable;
            }
            catch (SQLException e) {
                logger.log(Level.DEBUG, e);
                return false;
            }
        }
        Resources.close(connection);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean activate(D database, SynchronizationStrategy strategy) throws SQLException, InterruptedException {
        if (!this.isAlive(database)) {
            return false;
        }
        Lock lock = this.lockManager.writeLock(null);
        lock.lockInterruptibly();
        try {
            if (this.balancer.contains(database)) {
                boolean bl = false;
                return bl;
            }
            if (!this.balancer.isEmpty()) {
                SynchronizationContextImpl context = new SynchronizationContextImpl(this, database);
                try {
                    DatabaseEvent event = new DatabaseEvent((Database<?>)database);
                    logger.log(Level.INFO, Messages.DATABASE_SYNC_START.getMessage(this, database), new Object[0]);
                    for (SynchronizationListener listener : this.synchronizationListeners) {
                        listener.beforeSynchronization(event);
                    }
                    strategy.synchronize(context);
                    logger.log(Level.INFO, Messages.DATABASE_SYNC_END.getMessage(this, database), new Object[0]);
                    for (SynchronizationListener listener : this.synchronizationListeners) {
                        listener.afterSynchronization(event);
                    }
                }
                finally {
                    context.close();
                }
            }
            boolean bl = this.activate(database, this.stateManager);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    class AutoActivationTask
    implements Runnable {
        AutoActivationTask() {
        }

        @Override
        public void run() {
            if (!DatabaseClusterImpl.this.getStateManager().isEnabled()) {
                return;
            }
            try {
                Balancer activeDatabases = DatabaseClusterImpl.this.getBalancer();
                if (!activeDatabases.isEmpty()) {
                    for (Database database : DatabaseClusterImpl.this.configuration.getDatabaseMap().values()) {
                        if (activeDatabases.contains(database)) continue;
                        try {
                            if (!DatabaseClusterImpl.this.activate(database, DatabaseClusterImpl.this.configuration.getSynchronizationStrategyMap().get(DatabaseClusterImpl.this.configuration.getDefaultSynchronizationStrategy()))) continue;
                            logger.log(Level.INFO, Messages.DATABASE_ACTIVATED.getMessage(new Object[0]), database, DatabaseClusterImpl.this);
                        }
                        catch (SQLException e) {
                            logger.log(Level.DEBUG, e);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    class FailureDetectionTask
    implements Runnable {
        FailureDetectionTask() {
        }

        @Override
        public void run() {
            if (!DatabaseClusterImpl.this.getStateManager().isEnabled()) {
                return;
            }
            Balancer databases = DatabaseClusterImpl.this.getBalancer();
            int size = databases.size();
            if (size > 1 || DatabaseClusterImpl.this.configuration.isEmptyClusterAllowed()) {
                ArrayList<Database> deadList = new ArrayList<Database>(size);
                for (Database database : databases) {
                    if (DatabaseClusterImpl.this.isAlive(database)) continue;
                    deadList.add(database);
                }
                if (deadList.size() < size || DatabaseClusterImpl.this.configuration.isEmptyClusterAllowed()) {
                    for (Database database : deadList) {
                        if (!DatabaseClusterImpl.this.deactivate(database, DatabaseClusterImpl.this.getStateManager())) continue;
                        logger.log(Level.ERROR, Messages.DATABASE_DEACTIVATED.getMessage(new Object[0]), database, DatabaseClusterImpl.this);
                    }
                }
            }
        }
    }
}

