/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.ChildInvocationHandler;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.util.reflect.Methods;

public class DatabaseMetaDataInvocationHandler<Z, D extends Database<Z>>
extends ChildInvocationHandler<Z, D, Connection, DatabaseMetaData, SQLException> {
    private static final Set<Method> databaseReadMethodSet = Methods.findMethods(DatabaseMetaData.class, "getAttributes", "getBestRowIdentifier", "getCatalogs", "getColumnPrivileges", "getColumns", "getCrossReference", "getExportedKeys", "getFunctionColumns", "getFunctions", "getImportedKeys", "getIndexInfo", "getPrimaryKeys", "getProcedureColumns", "getProcedures", "getPseudoColumns", "getSchemas", "getSuperTables", "getSuperTypes", "getTablePrivileges", "getTables", "getUDTs", "getVersionColumns");
    private static final Method getConnectionMethod = Methods.getMethod(DatabaseMetaData.class, "getConnection", new Class[0]);

    public DatabaseMetaDataInvocationHandler(Connection parent, SQLProxy<Z, D, Connection, SQLException> proxy, Invoker<Z, D, Connection, DatabaseMetaData, SQLException> invoker, Map<D, DatabaseMetaData> objectMap) {
        super(parent, proxy, invoker, DatabaseMetaData.class, SQLException.class, objectMap);
    }

    @Override
    protected Method getParentMethod() {
        return getConnectionMethod;
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(DatabaseMetaData metaData, Method method, Object[] parameters) throws SQLException {
        if (databaseReadMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_NEXT;
        }
        return InvocationStrategyEnum.INVOKE_ON_ANY;
    }

    @Override
    protected void close(Connection parent, DatabaseMetaData object) throws SQLException {
    }
}

