/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sf.hajdbc.AbstractDriver;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DatabaseClusterConfigurationFactory;
import net.sf.hajdbc.DatabaseClusterFactory;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.sql.AbstractInvocationHandler;
import net.sf.hajdbc.sql.ConnectionInvocationHandlerFactory;
import net.sf.hajdbc.sql.DatabaseClusterFactoryImpl;
import net.sf.hajdbc.sql.DriverDatabase;
import net.sf.hajdbc.sql.DriverDatabaseClusterConfiguration;
import net.sf.hajdbc.sql.DriverInvocationHandler;
import net.sf.hajdbc.sql.LocalTransactionContext;
import net.sf.hajdbc.util.concurrent.LifecycleRegistry;
import net.sf.hajdbc.util.concurrent.MapRegistryStoreFactory;
import net.sf.hajdbc.util.concurrent.Registry;
import net.sf.hajdbc.util.reflect.ProxyFactory;
import net.sf.hajdbc.xml.XMLDatabaseClusterConfigurationFactory;

public final class Driver
extends AbstractDriver
implements Registry.Factory<String, DatabaseCluster<java.sql.Driver, DriverDatabase>, Properties, SQLException> {
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:ha-jdbc:(?://)?([^/]+)(?:/.+)?");
    private static final String CONFIG = "config";
    private static final net.sf.hajdbc.logging.Logger logger = LoggerFactory.getLogger(Driver.class);
    private volatile DatabaseClusterFactory<java.sql.Driver, DriverDatabase> factory = new DatabaseClusterFactoryImpl<java.sql.Driver, DriverDatabase>();
    private volatile long timeout = 10L;
    private volatile TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private final Map<String, DatabaseClusterConfigurationFactory<java.sql.Driver, DriverDatabase>> configurationFactories = new ConcurrentHashMap<String, DatabaseClusterConfigurationFactory<java.sql.Driver, DriverDatabase>>();
    private final Registry<String, DatabaseCluster<java.sql.Driver, DriverDatabase>, Properties, SQLException> registry = new LifecycleRegistry<String, DatabaseCluster<java.sql.Driver, DriverDatabase>, Properties, SQLException>(this, new MapRegistryStoreFactory(), ExceptionType.getExceptionFactory(SQLException.class));

    public void stop(String id) throws SQLException {
        this.registry.remove(id);
    }

    public void setFactory(DatabaseClusterFactory<java.sql.Driver, DriverDatabase> factory) {
        this.factory = factory;
    }

    public Map<String, DatabaseClusterConfigurationFactory<java.sql.Driver, DriverDatabase>> getConfigurationFactories() {
        return this.configurationFactories;
    }

    public void setTimeout(long value, TimeUnit unit) {
        this.timeout = value;
        this.timeoutUnit = unit;
    }

    @Override
    protected Pattern getUrlPattern() {
        return URL_PATTERN;
    }

    @Override
    public Connection connect(String url, final Properties properties) throws SQLException {
        String id = this.parse(url);
        if (id == null) {
            return null;
        }
        DatabaseCluster<java.sql.Driver, DriverDatabase> cluster = this.registry.get(id, properties);
        DriverInvocationHandler handler = new DriverInvocationHandler(cluster);
        java.sql.Driver driver = ProxyFactory.createProxy(java.sql.Driver.class, handler);
        Invoker<java.sql.Driver, DriverDatabase, java.sql.Driver, Connection, SQLException> invoker = new Invoker<java.sql.Driver, DriverDatabase, java.sql.Driver, Connection, SQLException>(){

            @Override
            public Connection invoke(DriverDatabase database, java.sql.Driver driver) throws SQLException {
                return driver.connect(database.getLocation(), properties);
            }
        };
        SortedMap<DriverDatabase, Connection> results = InvocationStrategyEnum.INVOKE_ON_ALL.invoke(handler, invoker);
        LocalTransactionContext<java.sql.Driver, DriverDatabase> context = new LocalTransactionContext<java.sql.Driver, DriverDatabase>(cluster);
        ConnectionInvocationHandlerFactory handlerFactory = new ConnectionInvocationHandlerFactory(context);
        DriverInvocationHandler driverInvocationHandler = handler;
        driverInvocationHandler.getClass();
        AbstractInvocationHandler.ProxyInvocationResultFactory<Connection> resultFactory = driverInvocationHandler.new AbstractInvocationHandler.ProxyInvocationResultFactory<Connection>(handlerFactory, driver, invoker);
        return resultFactory.createResult(results);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, final Properties properties) throws SQLException {
        String id = this.parse(url);
        if (id == null) {
            return null;
        }
        DatabaseCluster<java.sql.Driver, DriverDatabase> cluster = this.registry.get(id, properties);
        DriverInvocationHandler handler = new DriverInvocationHandler(cluster);
        Invoker<java.sql.Driver, DriverDatabase, java.sql.Driver, DriverPropertyInfo[], SQLException> invoker = new Invoker<java.sql.Driver, DriverDatabase, java.sql.Driver, DriverPropertyInfo[], SQLException>(){

            @Override
            public DriverPropertyInfo[] invoke(DriverDatabase database, java.sql.Driver driver) throws SQLException {
                return driver.getPropertyInfo(database.getLocation(), properties);
            }
        };
        SortedMap<DriverDatabase, DriverPropertyInfo[]> results = InvocationStrategyEnum.INVOKE_ON_NEXT.invoke(handler, invoker);
        AbstractInvocationHandler.SimpleInvocationResultFactory<DriverPropertyInfo[]> resultFactory = handler.new AbstractInvocationHandler.SimpleInvocationResultFactory<DriverPropertyInfo[]>();
        return resultFactory.createResult(results);
    }

    @Override
    public DatabaseCluster<java.sql.Driver, DriverDatabase> create(String id, Properties properties) throws SQLException {
        DatabaseClusterConfigurationFactory<java.sql.Driver, DriverDatabase> factory = this.configurationFactories.get(id);
        if (factory == null) {
            factory = new XMLDatabaseClusterConfigurationFactory<java.sql.Driver, DriverDatabase>(DriverDatabaseClusterConfiguration.class, id, properties.getProperty(CONFIG));
        }
        return this.factory.createDatabaseCluster(id, factory);
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            logger.log(Level.ERROR, Messages.DRIVER_REGISTER_FAILED.getMessage(Driver.class.getName()), e);
        }
    }
}

