/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlType;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.management.Description;
import net.sf.hajdbc.management.MBean;
import net.sf.hajdbc.management.ManagedAttribute;
import net.sf.hajdbc.sql.AbstractDatabase;

@MBean
@Description(value="Database accessed via DriverManager")
@XmlType(name="database")
public class DriverDatabase
extends AbstractDatabase<Driver> {
    private static final String USER = "user";
    private static final String PASSWORD = "password";

    @Override
    @ManagedAttribute
    @Description(value="JDBC url")
    public void setLocation(String location) {
        this.getDriver(location);
        super.setLocation(location);
    }

    @Override
    public Connection connect(Driver driver, String password) throws SQLException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        if (this.requiresAuthentication()) {
            properties.setProperty(USER, this.getUser());
            if (password != null) {
                properties.setProperty(PASSWORD, password);
            }
        }
        return driver.connect(this.getLocation(), properties);
    }

    @Override
    public Driver createConnectionSource() {
        return this.getDriver(this.getLocation());
    }

    public String parseVendor() {
        String url = this.getLocation();
        return url.substring(5, url.indexOf(":", 5));
    }

    private Driver getDriver(String url) {
        try {
            return DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(Messages.JDBC_URL_REJECTED.getMessage(url), e);
        }
    }
}

