/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.hajdbc.durability.Durability;
import net.sf.hajdbc.util.SimpleStaticRegistry;
import net.sf.hajdbc.util.StaticRegistry;

public class DurabilityPhaseRegistry
implements StaticRegistry<Method, Durability.Phase>,
SimpleStaticRegistry.ExceptionMessageFactory<Method> {
    private final StaticRegistry<Method, Durability.Phase> registry;

    public DurabilityPhaseRegistry(List<Method> commitMethods, List<Method> rollbackMethods) {
        this(Collections.emptyList(), commitMethods, rollbackMethods, Collections.emptyList());
    }

    public DurabilityPhaseRegistry(List<Method> prepareMethods, List<Method> commitMethods, List<Method> rollbackMethods, List<Method> forgetMethods) {
        HashMap<Method, Durability.Phase> map = new HashMap<Method, Durability.Phase>();
        for (Method method : prepareMethods) {
            map.put(method, Durability.Phase.PREPARE);
        }
        for (Method method : commitMethods) {
            map.put(method, Durability.Phase.COMMIT);
        }
        for (Method method : rollbackMethods) {
            map.put(method, Durability.Phase.ROLLBACK);
        }
        for (Method method : forgetMethods) {
            map.put(method, Durability.Phase.FORGET);
        }
        this.registry = new SimpleStaticRegistry<Method, Durability.Phase>(this, map);
    }

    @Override
    public Durability.Phase get(Method method) {
        return this.registry.get(method);
    }

    @Override
    public String createMessage(Method method) {
        return String.format("%s.%s(...) has no associated durability phase.", method.getClass().getName(), method.getName());
    }
}

