/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.LinkedList;
import java.util.List;
import net.sf.hajdbc.ExceptionFactory;
import net.sf.hajdbc.sql.FileSupport;
import net.sf.hajdbc.util.Files;
import net.sf.hajdbc.util.Resources;

public class FileSupportImpl<E extends Exception>
implements FileSupport<E> {
    private static final String TEMP_FILE_SUFFIX = ".lob";
    private static final int BUFFER_SIZE = 8192;
    private final List<File> files = new LinkedList<File>();
    private final ExceptionFactory<E> exceptionFactory;

    public FileSupportImpl(ExceptionFactory<E> exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File createFile(InputStream inputStream) throws E {
        File file;
        File file2 = this.createTempFile();
        FileOutputStream output = new FileOutputStream(file2);
        try {
            FileChannel fileChannel = output.getChannel();
            ReadableByteChannel inputChannel = Channels.newChannel(inputStream);
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            while (inputChannel.read(buffer) > 0) {
                buffer.flip();
                fileChannel.write(buffer);
                buffer.compact();
            }
            file = file2;
        }
        catch (Throwable throwable) {
            try {
                Resources.close(output);
                throw throwable;
            }
            catch (IOException e) {
                throw this.exceptionFactory.createException(e);
            }
        }
        Resources.close(output);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File createFile(Reader reader) throws E {
        File file;
        File file2 = this.createTempFile();
        FileWriter writer = new FileWriter(file2);
        try {
            CharBuffer buffer = CharBuffer.allocate(8192);
            while (reader.read(buffer) > 0) {
                buffer.flip();
                ((Writer)writer).append(buffer);
                buffer.clear();
            }
            file = file2;
        }
        catch (Throwable throwable) {
            try {
                Resources.close(writer);
                throw throwable;
            }
            catch (IOException e) {
                throw this.exceptionFactory.createException(e);
            }
        }
        Resources.close(writer);
        return file;
    }

    @Override
    public Reader getReader(File file) throws E {
        try {
            return new BufferedReader(new FileReader(file), 8192);
        }
        catch (IOException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    @Override
    public InputStream getInputStream(File file) throws E {
        try {
            return Channels.newInputStream(new FileInputStream(file).getChannel());
        }
        catch (IOException e) {
            throw this.exceptionFactory.createException(e);
        }
    }

    private File createTempFile() throws IOException {
        File file = Files.createTempFile(TEMP_FILE_SUFFIX);
        this.files.add(file);
        return file;
    }

    @Override
    public void close() {
        for (File file : this.files) {
            if (file.delete()) continue;
            file.deleteOnExit();
        }
        this.files.clear();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

