/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.SortedMap;
import java.util.concurrent.locks.Lock;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.durability.Durability;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.sql.TransactionContext;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;

public class LocalTransactionContext<Z, D extends Database<Z>>
implements TransactionContext<Z, D> {
    final Durability<Z, D> durability;
    private final Lock lock;
    private final TransactionIdentifierFactory<? extends Object> transactionIdFactory;
    volatile Object transactionId;

    public LocalTransactionContext(DatabaseCluster<Z, D> cluster) {
        this.lock = cluster.getLockManager().readLock(null);
        this.durability = cluster.getDurability();
        this.transactionIdFactory = cluster.getTransactionIdentifierFactory();
    }

    @Override
    public InvocationStrategy start(final InvocationStrategy strategy, Connection connection) throws SQLException {
        if (this.transactionId != null) {
            return strategy;
        }
        if (connection.getAutoCommit()) {
            return new InvocationStrategy(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public <ZZ, DD extends Database<ZZ>, T, R, E extends Exception> SortedMap<DD, R> invoke(SQLProxy<ZZ, DD, T, E> proxy, Invoker<ZZ, DD, T, R, E> invoker) throws E {
                    LocalTransactionContext.this.lock();
                    try {
                        InvocationStrategy durabilityStrategy = LocalTransactionContext.this.durability.getInvocationStrategy(strategy, Durability.Phase.COMMIT, LocalTransactionContext.this.transactionId);
                        SortedMap<DD, R> sortedMap = durabilityStrategy.invoke(proxy, invoker);
                        return sortedMap;
                    }
                    finally {
                        LocalTransactionContext.this.unlock();
                    }
                }
            };
        }
        return new InvocationStrategy(){

            public <ZZ, DD extends Database<ZZ>, T, R, E extends Exception> SortedMap<DD, R> invoke(SQLProxy<ZZ, DD, T, E> proxy, Invoker<ZZ, DD, T, R, E> invoker) throws E {
                LocalTransactionContext.this.lock();
                try {
                    return strategy.invoke(proxy, invoker);
                }
                catch (Throwable e) {
                    LocalTransactionContext.this.unlock();
                    throw proxy.getExceptionFactory().createException(e);
                }
            }
        };
    }

    @Override
    public <T, R> Invoker<Z, D, T, R, SQLException> start(final Invoker<Z, D, T, R, SQLException> invoker, Connection connection) throws SQLException {
        if (this.transactionId == null || !connection.getAutoCommit()) {
            return invoker;
        }
        return new Invoker<Z, D, T, R, SQLException>(){

            @Override
            public R invoke(D database, T object) throws SQLException {
                return LocalTransactionContext.this.durability.getInvoker(invoker, Durability.Phase.COMMIT, LocalTransactionContext.this.transactionId, ExceptionType.getExceptionFactory(SQLException.class)).invoke(database, object);
            }
        };
    }

    @Override
    public InvocationStrategy end(final InvocationStrategy strategy, final Durability.Phase phase) {
        if (this.transactionId == null) {
            return strategy;
        }
        return new InvocationStrategy(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <ZZ, DD extends Database<ZZ>, T, R, E extends Exception> SortedMap<DD, R> invoke(SQLProxy<ZZ, DD, T, E> proxy, Invoker<ZZ, DD, T, R, E> invoker) throws E {
                InvocationStrategy durabilityStrategy = LocalTransactionContext.this.durability.getInvocationStrategy(strategy, phase, LocalTransactionContext.this.transactionId);
                try {
                    SortedMap<DD, R> sortedMap = durabilityStrategy.invoke(proxy, invoker);
                    return sortedMap;
                }
                finally {
                    LocalTransactionContext.this.unlock();
                }
            }
        };
    }

    @Override
    public <T, R> Invoker<Z, D, T, R, SQLException> end(Invoker<Z, D, T, R, SQLException> invoker, Durability.Phase phase) throws SQLException {
        if (this.transactionId == null) {
            return invoker;
        }
        return this.durability.getInvoker(invoker, phase, this.transactionId, ExceptionType.getExceptionFactory(SQLException.class));
    }

    @Override
    public void close() {
        if (this.transactionId != null) {
            this.unlock();
        }
    }

    void lock() {
        this.lock.lock();
        this.transactionId = this.transactionIdFactory.createTransactionIdentifier();
    }

    void unlock() {
        this.lock.unlock();
        this.transactionId = null;
    }
}

