/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.sql.ChildInvocationHandler;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.util.reflect.Methods;

public abstract class LocatorInvocationHandler<Z, D extends Database<Z>, P, T>
extends ChildInvocationHandler<Z, D, P, T, SQLException> {
    private final Method freeMethod;
    private final Set<Method> readMethodSet;
    private final Set<Method> writeMethodSet;
    private final List<Invoker<Z, D, T, ?, SQLException>> invokerList = new LinkedList();
    private final boolean updateCopy;

    protected LocatorInvocationHandler(P parent, SQLProxy<Z, D, P, SQLException> proxy, Invoker<Z, D, P, T, SQLException> invoker, Class<T> locatorClass, Map<D, T> locators, boolean updateCopy, Set<Method> readMethodSet, Set<Method> writeMethodSet) {
        super(parent, proxy, invoker, locatorClass, SQLException.class, locators);
        this.freeMethod = Methods.findMethod(locatorClass, "free", new Class[0]);
        this.updateCopy = updateCopy;
        this.readMethodSet = readMethodSet;
        this.writeMethodSet = writeMethodSet;
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(T locator, Method method, Object[] parameters) throws SQLException {
        if (this.readMethodSet.contains(method)) {
            return this.updateCopy ? InvocationStrategyEnum.INVOKE_ON_ANY : InvocationStrategyEnum.INVOKE_ON_NEXT;
        }
        if (this.updateCopy && this.writeMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_EXISTING;
        }
        return super.getInvocationStrategy(locator, method, parameters);
    }

    @Override
    protected void postInvoke(T object, Method method, Object[] parameters) {
        if (this.freeMethod != null && method.equals(this.freeMethod)) {
            this.getParentProxy().removeChild(this);
        }
    }

    @Override
    protected void close(P parent, T locator) {
        if (this.freeMethod != null) {
            try {
                this.free(locator);
            }
            catch (SQLException e) {
                this.logger.log(Level.WARN, e, e.getMessage(), new Object[0]);
            }
        }
    }

    protected abstract void free(T var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void record(Invoker<Z, D, T, ?, SQLException> invoker, Method method, Object[] parameters) {
        if (this.isRecordable(method)) {
            List<Invoker<Z, D, T, ?, SQLException>> list = this.invokerList;
            synchronized (list) {
                this.invokerList.add(invoker);
            }
        }
    }
}

