/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.lang.reflect.InvocationHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.InvocationHandlerFactory;
import net.sf.hajdbc.sql.SQLProxy;

public abstract class LocatorInvocationHandlerFactory<Z, D extends Database<Z>, P, T>
implements InvocationHandlerFactory<Z, D, P, T, SQLException> {
    private final Class<T> locatorClass;
    private final Connection connection;

    protected LocatorInvocationHandlerFactory(Class<T> locatorClass, Connection connection) {
        this.locatorClass = locatorClass;
        this.connection = connection;
    }

    @Override
    public InvocationHandler createInvocationHandler(P parent, SQLProxy<Z, D, P, SQLException> proxy, Invoker<Z, D, P, T, SQLException> invoker, Map<D, T> locators) throws SQLException {
        DatabaseCluster<Z, D> cluster = proxy.getDatabaseCluster();
        return this.createInvocationHandler(parent, proxy, invoker, locators, cluster.getDatabaseMetaDataCache().getDatabaseProperties(cluster.getBalancer().next(), this.connection).locatorsUpdateCopy());
    }

    protected abstract InvocationHandler createInvocationHandler(P var1, SQLProxy<Z, D, P, SQLException> var2, Invoker<Z, D, P, T, SQLException> var3, Map<D, T> var4, boolean var5) throws SQLException;

    @Override
    public Class<T> getTargetClass() {
        return this.locatorClass;
    }
}

