/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.locks.Lock;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.SQLProxy;

public class LockingInvocationStrategy
implements InvocationStrategy {
    private InvocationStrategy strategy;
    private List<Lock> lockList;

    public LockingInvocationStrategy(InvocationStrategy strategy, List<Lock> lockList) {
        this.strategy = strategy;
        this.lockList = lockList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Z, D extends Database<Z>, T, R, E extends Exception> SortedMap<D, R> invoke(SQLProxy<Z, D, T, E> proxy, Invoker<Z, D, T, R, E> invoker) throws E {
        for (Lock lock : this.lockList) {
            lock.lock();
        }
        try {
            SortedMap<D, R> sortedMap = this.strategy.invoke(proxy, invoker);
            return sortedMap;
        }
        finally {
            for (Lock lock : this.lockList) {
                lock.unlock();
            }
        }
    }
}

