/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.BlobInvocationHandlerFactory;
import net.sf.hajdbc.sql.ChildInvocationHandler;
import net.sf.hajdbc.sql.ClobInvocationHandlerFactory;
import net.sf.hajdbc.sql.FileSupport;
import net.sf.hajdbc.sql.InvocationHandlerFactory;
import net.sf.hajdbc.sql.NClobInvocationHandlerFactory;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.sql.SQLXMLInvocationHandlerFactory;
import net.sf.hajdbc.sql.TransactionContext;
import net.sf.hajdbc.util.reflect.Methods;
import net.sf.hajdbc.util.reflect.ProxyFactory;
import net.sf.hajdbc.util.reflect.SimpleInvocationHandler;

public class ResultSetInvocationHandler<Z, D extends Database<Z>, S extends Statement>
extends ChildInvocationHandler<Z, D, S, ResultSet, SQLException> {
    private static final Set<Method> driverReadMethodSet = Methods.findMethods(ResultSet.class, "findColumn", "getConcurrency", "getCursorName", "getFetchDirection", "getFetchSize", "getHoldability", "getMetaData", "getRow", "getType", "getWarnings", "isAfterLast", "isBeforeFirst", "isClosed", "isFirst", "isLast", "row(Deleted|Inserted|Updated)", "wasNull");
    private static final Set<Method> driverWriteMethodSet = Methods.findMethods(ResultSet.class, "absolute", "afterLast", "beforeFirst", "cancelRowUpdates", "clearWarnings", "first", "last", "moveTo(Current|Insert)Row", "next", "previous", "relative", "setFetchDirection", "setFetchSize");
    private static final Set<Method> transactionalWriteMethodSet = Methods.findMethods(ResultSet.class, "(delete|insert|update)Row");
    private static final Set<Method> getBlobMethodSet = Methods.findMethods(ResultSet.class, "getBlob");
    private static final Set<Method> getClobMethodSet = Methods.findMethods(ResultSet.class, "getClob");
    private static final Set<Method> getNClobMethodSet = Methods.findMethods(ResultSet.class, "getNClob");
    private static final Set<Method> getSQLXMLMethodSet = Methods.findMethods(ResultSet.class, "getSQLXML");
    private static final Method closeMethod = Methods.getMethod(ResultSet.class, "close", new Class[0]);
    private static final Method getStatementMethod = Methods.getMethod(ResultSet.class, "getStatement", new Class[0]);
    protected FileSupport<SQLException> fileSupport;
    private TransactionContext<Z, D> transactionContext;
    private List<Invoker<Z, D, ResultSet, ?, SQLException>> invokerList = new LinkedList();

    protected ResultSetInvocationHandler(S statement, SQLProxy<Z, D, S, SQLException> proxy, Invoker<Z, D, S, ResultSet, SQLException> invoker, Map<D, ResultSet> resultSetMap, TransactionContext<Z, D> transactionContext, FileSupport<SQLException> fileSupport) {
        super(statement, proxy, invoker, ResultSet.class, SQLException.class, resultSetMap);
        this.transactionContext = transactionContext;
        this.fileSupport = fileSupport;
    }

    @Override
    protected Method getParentMethod() {
        return getStatementMethod;
    }

    @Override
    protected InvocationHandlerFactory<Z, D, ResultSet, ?, SQLException> getInvocationHandlerFactory(ResultSet object, Method method, Object[] parameters) throws SQLException {
        if (getBlobMethodSet.contains(method)) {
            return new BlobInvocationHandlerFactory(((Statement)this.getParent()).getConnection());
        }
        if (getClobMethodSet.contains(method)) {
            return new ClobInvocationHandlerFactory(((Statement)this.getParent()).getConnection());
        }
        if (getNClobMethodSet.contains(method)) {
            return new NClobInvocationHandlerFactory(((Statement)this.getParent()).getConnection());
        }
        if (getSQLXMLMethodSet.contains(method)) {
            return new SQLXMLInvocationHandlerFactory(((Statement)this.getParent()).getConnection());
        }
        return super.getInvocationHandlerFactory(object, method, parameters);
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(ResultSet resultSet, Method method, Object[] parameters) throws SQLException {
        if (driverReadMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ANY;
        }
        if (driverWriteMethodSet.contains(method) || method.equals(closeMethod)) {
            return InvocationStrategyEnum.INVOKE_ON_EXISTING;
        }
        if (transactionalWriteMethodSet.contains(method)) {
            return this.transactionContext.start(InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL, ((Statement)this.getParent()).getConnection());
        }
        if (this.isGetMethod(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ANY;
        }
        if (this.isUpdateMethod(method)) {
            return InvocationStrategyEnum.INVOKE_ON_EXISTING;
        }
        return super.getInvocationStrategy(resultSet, method, parameters);
    }

    @Override
    protected <R> Invoker<Z, D, ResultSet, R, SQLException> getInvoker(ResultSet object, final Method method, final Object[] parameters) throws SQLException {
        Object typeParameter;
        if (this.isUpdateMethod(method) && parameters.length > 1 && (typeParameter = parameters[1]) != null) {
            Class<?> type = method.getParameterTypes()[1];
            if (type.equals(InputStream.class)) {
                final File file = this.fileSupport.createFile((InputStream)typeParameter);
                return new Invoker<Z, D, ResultSet, R, SQLException>(){

                    @Override
                    public R invoke(D database, ResultSet resultSet) throws SQLException {
                        ArrayList<Object> parameterList = new ArrayList<Object>(Arrays.asList(parameters));
                        parameterList.set(1, ResultSetInvocationHandler.this.fileSupport.getInputStream(file));
                        return Methods.invoke(method, ResultSetInvocationHandler.this.getExceptionFactory(), resultSet, parameterList.toArray());
                    }
                };
            }
            if (type.equals(Reader.class)) {
                final File file = this.fileSupport.createFile((Reader)typeParameter);
                return new Invoker<Z, D, ResultSet, R, SQLException>(){

                    @Override
                    public R invoke(D database, ResultSet resultSet) throws SQLException {
                        ArrayList<Object> parameterList = new ArrayList<Object>(Arrays.asList(parameters));
                        parameterList.set(1, ResultSetInvocationHandler.this.fileSupport.getReader(file));
                        return Methods.invoke(method, ResultSetInvocationHandler.this.getExceptionFactory(), resultSet, parameterList.toArray());
                    }
                };
            }
            if (type.equals(Blob.class)) {
                Blob blob = (Blob)typeParameter;
                if (Proxy.isProxyClass(blob.getClass()) && Proxy.getInvocationHandler(blob) instanceof SQLProxy) {
                    final SQLProxy proxy = this.getInvocationHandler(blob);
                    return new Invoker<Z, D, ResultSet, R, SQLException>(){

                        @Override
                        public R invoke(D database, ResultSet resultSet) throws SQLException {
                            ArrayList<Object> parameterList = new ArrayList<Object>(Arrays.asList(parameters));
                            parameterList.set(1, proxy.getObject(database));
                            return Methods.invoke(method, ResultSetInvocationHandler.this.getExceptionFactory(), resultSet, parameterList.toArray());
                        }
                    };
                }
                parameters[1] = new SerialBlob(blob);
            }
            if (Clob.class.isAssignableFrom(type)) {
                Clob clob = (Clob)typeParameter;
                if (Proxy.isProxyClass(clob.getClass()) && Proxy.getInvocationHandler(clob) instanceof SQLProxy) {
                    final SQLProxy proxy = this.getInvocationHandler(clob);
                    return new Invoker<Z, D, ResultSet, R, SQLException>(){

                        @Override
                        public R invoke(D database, ResultSet resultSet) throws SQLException {
                            ArrayList<Object> parameterList = new ArrayList<Object>(Arrays.asList(parameters));
                            parameterList.set(1, proxy.getObject(database));
                            return Methods.invoke(method, ResultSetInvocationHandler.this.getExceptionFactory(), resultSet, parameterList.toArray());
                        }
                    };
                }
                SerialClob serialClob = new SerialClob(clob);
                parameters[1] = type.equals(Clob.class) ? serialClob : ProxyFactory.createProxy(type, new SimpleInvocationHandler(serialClob));
            }
        }
        return super.getInvoker(object, method, parameters);
    }

    @Override
    protected void postInvoke(ResultSet object, Method method, Object[] parameters) {
        if (method.equals(closeMethod)) {
            this.getParentProxy().removeChild(this);
        }
    }

    @Override
    protected void close(S statement, ResultSet resultSet) throws SQLException {
        resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void record(Invoker<Z, D, ResultSet, ?, SQLException> invoker, Method method, Object[] parameters) {
        if (driverWriteMethodSet.contains(method) || this.isUpdateMethod(method)) {
            List<Invoker<Z, D, ResultSet, ?, SQLException>> list = this.invokerList;
            synchronized (list) {
                this.invokerList.add(invoker);
            }
        } else {
            super.record(invoker, method, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replay(D database, ResultSet resultSet) throws SQLException {
        super.replay(database, resultSet);
        List<Invoker<Z, D, ResultSet, ?, SQLException>> list = this.invokerList;
        synchronized (list) {
            for (Invoker<Z, D, ResultSet, ?, SQLException> invoker : this.invokerList) {
                invoker.invoke(database, resultSet);
            }
        }
    }

    private boolean isGetMethod(Method method) {
        Class<?>[] types = method.getParameterTypes();
        return method.getName().startsWith("get") && types != null && types.length > 0 && (types[0].equals(String.class) || types[0].equals(Integer.TYPE));
    }

    private boolean isUpdateMethod(Method method) {
        Class<?>[] types = method.getParameterTypes();
        return method.getName().startsWith("update") && types != null && types.length > 0 && (types[0].equals(String.class) || types[0].equals(Integer.TYPE));
    }
}

