/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql.pool;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.ConnectionPoolDataSource;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.sql.CommonDataSourceInvocationHandler;
import net.sf.hajdbc.sql.InvocationHandlerFactory;
import net.sf.hajdbc.sql.pool.ConnectionPoolDataSourceDatabase;
import net.sf.hajdbc.sql.pool.PooledConnectionInvocationHandlerFactory;
import net.sf.hajdbc.util.reflect.Methods;

public class ConnectionPoolDataSourceInvocationHandler
extends CommonDataSourceInvocationHandler<ConnectionPoolDataSource, ConnectionPoolDataSourceDatabase> {
    private static final Set<Method> getPooledConnectionMethodSet = Methods.findMethods(ConnectionPoolDataSource.class, "getPooledConnection");

    public ConnectionPoolDataSourceInvocationHandler(DatabaseCluster<ConnectionPoolDataSource, ConnectionPoolDataSourceDatabase> databaseCluster) {
        super(databaseCluster, ConnectionPoolDataSource.class);
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(ConnectionPoolDataSource dataSource, Method method, Object[] parameters) throws SQLException {
        if (getPooledConnectionMethodSet.contains(method)) {
            return InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL;
        }
        return super.getInvocationStrategy(dataSource, method, parameters);
    }

    @Override
    protected InvocationHandlerFactory<ConnectionPoolDataSource, ConnectionPoolDataSourceDatabase, ConnectionPoolDataSource, ?, SQLException> getInvocationHandlerFactory(ConnectionPoolDataSource object, Method method, Object[] parameters) throws SQLException {
        if (getPooledConnectionMethodSet.contains(method)) {
            return new PooledConnectionInvocationHandlerFactory();
        }
        return super.getInvocationHandlerFactory(object, method, parameters);
    }
}

