/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.xml.bind.annotation.XmlType;
import net.sf.hajdbc.management.Description;
import net.sf.hajdbc.management.MBean;
import net.sf.hajdbc.sql.CommonDataSourceDatabase;

@MBean
@Description(value="Database accessed via a server-side XADataSource")
@XmlType(name="database")
public class XADataSourceDatabase
extends CommonDataSourceDatabase<XADataSource> {
    private boolean force2PC = false;

    public XADataSourceDatabase() {
        super(XADataSource.class);
    }

    @Override
    public Connection connect(XADataSource dataSource, String password) throws SQLException {
        XAConnection connection = this.requiresAuthentication() ? dataSource.getXAConnection(this.getUser(), password) : dataSource.getXAConnection();
        return connection.getConnection();
    }

    public boolean isForce2PC() {
        return this.force2PC;
    }

    public void setForce2PC(boolean force) {
        this.force2PC = force;
    }
}

