/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql.xa;

import javax.sql.XADataSource;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.sf.hajdbc.sql.AbstractDatabaseClusterConfiguration;
import net.sf.hajdbc.sql.xa.XADataSourceDatabase;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;
import net.sf.hajdbc.tx.UUIDTransactionIdentifierFactory;

@XmlRootElement(name="ha-jdbc")
@XmlType(name="databaseClusterConfiguration")
public class XADataSourceDatabaseClusterConfiguration
extends AbstractDatabaseClusterConfiguration<XADataSource, XADataSourceDatabase> {
    private static final long serialVersionUID = 6548016448539963613L;
    @XmlElement(name="cluster", required=true)
    private XADataSourceNestedConfiguration configuration = new XADataSourceNestedConfiguration();

    @Override
    protected AbstractDatabaseClusterConfiguration.NestedConfiguration<XADataSource, XADataSourceDatabase> getNestedConfiguration() {
        return this.configuration;
    }

    @Override
    public TransactionIdentifierFactory<? extends Object> getTransactionIdentifierFactory() {
        return new UUIDTransactionIdentifierFactory();
    }

    @XmlType(name="nestedConfiguration")
    static class XADataSourceNestedConfiguration
    extends AbstractDatabaseClusterConfiguration.NestedConfiguration<XADataSource, XADataSourceDatabase> {
        private static final long serialVersionUID = 8096563929212126538L;

        XADataSourceNestedConfiguration() {
        }

        @XmlElement(name="database")
        private XADataSourceDatabase[] getDatabases() {
            return this.getDatabaseMap().values().toArray(new XADataSourceDatabase[this.getDatabaseMap().size()]);
        }

        private void setDatabases(XADataSourceDatabase[] databases) {
            for (XADataSourceDatabase database : databases) {
                this.getDatabaseMap().put(database.getId(), database);
            }
        }

        @Override
        public XADataSourceDatabase createDatabase(String id) {
            XADataSourceDatabase database = new XADataSourceDatabase();
            database.setId(id);
            return database;
        }
    }
}

