/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql.xa;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.XADataSource;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.sql.CommonDataSourceInvocationHandler;
import net.sf.hajdbc.sql.InvocationHandlerFactory;
import net.sf.hajdbc.sql.xa.XAConnectionInvocationHandlerFactory;
import net.sf.hajdbc.sql.xa.XADataSourceDatabase;
import net.sf.hajdbc.util.reflect.Methods;

public class XADataSourceInvocationHandler
extends CommonDataSourceInvocationHandler<XADataSource, XADataSourceDatabase> {
    private static final Set<Method> getXAConnectionMethodSet = Methods.findMethods(XADataSource.class, "getXAConnection");

    public XADataSourceInvocationHandler(DatabaseCluster<XADataSource, XADataSourceDatabase> databaseCluster) {
        super(databaseCluster, XADataSource.class);
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(XADataSource dataSource, Method method, Object[] parameters) throws SQLException {
        if (getXAConnectionMethodSet.contains(method)) {
            return InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL;
        }
        return super.getInvocationStrategy(dataSource, method, parameters);
    }

    @Override
    protected InvocationHandlerFactory<XADataSource, XADataSourceDatabase, XADataSource, ?, SQLException> getInvocationHandlerFactory(XADataSource object, Method method, Object[] parameters) throws SQLException {
        if (getXAConnectionMethodSet.contains(method)) {
            return new XAConnectionInvocationHandlerFactory();
        }
        return super.getInvocationHandlerFactory(object, method, parameters);
    }
}

