/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql.xa;

import javax.transaction.xa.XAException;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.durability.Durability;
import net.sf.hajdbc.sql.AbstractExceptionFactory;

public class XAExceptionFactory
extends AbstractExceptionFactory<XAException> {
    private static final long serialVersionUID = -8802252233361030433L;

    public XAExceptionFactory() {
        super(XAException.class);
    }

    @Override
    public XAException createException(String message) {
        return new XAException(message);
    }

    @Override
    public boolean equals(XAException exception1, XAException exception2) {
        String message2;
        if (exception1.errorCode != 0 || exception2.errorCode != 0) {
            return exception1.errorCode == exception2.errorCode;
        }
        String message1 = exception1.getMessage();
        return message1 == (message2 = exception2.getMessage()) || message1 != null && message2 != null && message1.equals(message2);
    }

    @Override
    public boolean indicatesFailure(XAException exception, Dialect dialect) {
        return dialect.indicatesFailure(exception);
    }

    @Override
    public ExceptionType getType() {
        return ExceptionType.XA;
    }

    @Override
    public boolean correctHeuristic(XAException exception, Durability.Phase phase) {
        switch (phase) {
            case COMMIT: {
                return exception.errorCode == 7;
            }
            case ROLLBACK: {
                return exception.errorCode == 6;
            }
        }
        return false;
    }
}

