/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sql.xa;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.durability.Durability;
import net.sf.hajdbc.invocation.InvocationStrategy;
import net.sf.hajdbc.invocation.InvocationStrategyEnum;
import net.sf.hajdbc.invocation.Invoker;
import net.sf.hajdbc.sql.AbstractChildInvocationHandler;
import net.sf.hajdbc.sql.DurabilityPhaseRegistry;
import net.sf.hajdbc.sql.SQLProxy;
import net.sf.hajdbc.sql.xa.XADataSourceDatabase;
import net.sf.hajdbc.util.StaticRegistry;
import net.sf.hajdbc.util.reflect.Methods;

public class XAResourceInvocationHandler
extends AbstractChildInvocationHandler<XADataSource, XADataSourceDatabase, XAConnection, SQLException, XAResource, XAException> {
    private static final Set<Method> driverReadMethodSet = Methods.findMethods(XAResource.class, "getTransactionTimeout", "isSameRM");
    private static final Set<Method> databaseWriteMethodSet = Methods.findMethods(XAResource.class, "setTransactionTimeout");
    private static final Set<Method> intraTransactionMethodSet = Methods.findMethods(XAResource.class, "prepare", "end", "recover");
    private static final Method prepareMethod = Methods.getMethod(XAResource.class, "prepare", Xid.class);
    private static final Method startMethod = Methods.getMethod(XAResource.class, "start", Xid.class, Integer.TYPE);
    private static final Method commitMethod = Methods.getMethod(XAResource.class, "commit", Xid.class, Boolean.TYPE);
    private static final Method rollbackMethod = Methods.getMethod(XAResource.class, "rollback", Xid.class);
    private static final Method forgetMethod = Methods.getMethod(XAResource.class, "forget", Xid.class);
    private static final Set<Method> endTransactionMethodSet = new HashSet<Method>(Arrays.asList(commitMethod, rollbackMethod, forgetMethod));
    private static final StaticRegistry<Method, Durability.Phase> phaseRegistry = new DurabilityPhaseRegistry(Arrays.asList(prepareMethod), Arrays.asList(commitMethod), Arrays.asList(rollbackMethod), Arrays.asList(forgetMethod));
    private static final ConcurrentMap<Xid, Lock> lockMap = new ConcurrentHashMap<Xid, Lock>();

    protected XAResourceInvocationHandler(XAConnection connection, SQLProxy<XADataSource, XADataSourceDatabase, XAConnection, SQLException> proxy, Invoker<XADataSource, XADataSourceDatabase, XAConnection, XAResource, SQLException> invoker, Map<XADataSourceDatabase, XAResource> objectMap) {
        super(connection, proxy, invoker, XAResource.class, XAException.class, objectMap);
    }

    @Override
    protected InvocationStrategy getInvocationStrategy(XAResource resource, Method method, Object[] parameters) throws XAException {
        if (driverReadMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ANY;
        }
        if (databaseWriteMethodSet.contains(method)) {
            return InvocationStrategyEnum.INVOKE_ON_ALL;
        }
        boolean start = method.equals(startMethod);
        boolean end = endTransactionMethodSet.contains(method);
        if (start || end || method.equals(prepareMethod) || intraTransactionMethodSet.contains(method)) {
            Lock lock;
            final InvocationStrategyEnum strategy = end ? InvocationStrategyEnum.END_TRANSACTION_INVOKE_ON_ALL : InvocationStrategyEnum.TRANSACTION_INVOKE_ON_ALL;
            Xid xid = (Xid)parameters[0];
            DatabaseCluster cluster = this.getDatabaseCluster();
            if (start && lockMap.putIfAbsent(xid, lock = cluster.getLockManager().readLock(null)) == null) {
                return new InvocationStrategy(){

                    @Override
                    public <Z, D extends Database<Z>, T, R, E extends Exception> SortedMap<D, R> invoke(SQLProxy<Z, D, T, E> proxy, Invoker<Z, D, T, R, E> invoker) throws E {
                        lock.lock();
                        try {
                            return strategy.invoke(proxy, invoker);
                        }
                        catch (Exception e) {
                            lock.unlock();
                            throw proxy.getExceptionFactory().createException(e);
                        }
                    }
                };
            }
            Durability.Phase phase = phaseRegistry.get(method);
            if (phase != null) {
                final InvocationStrategy durabilityStrategy = cluster.getDurability().getInvocationStrategy(strategy, phase, xid);
                if (endTransactionMethodSet.contains(method)) {
                    final Lock lock2 = (Lock)lockMap.remove(xid);
                    return new InvocationStrategy(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public <Z, D extends Database<Z>, T, R, E extends Exception> SortedMap<D, R> invoke(SQLProxy<Z, D, T, E> proxy, Invoker<Z, D, T, R, E> invoker) throws E {
                            try {
                                SortedMap<D, R> sortedMap = durabilityStrategy.invoke(proxy, invoker);
                                return sortedMap;
                            }
                            finally {
                                if (lock2 != null) {
                                    lock2.unlock();
                                }
                            }
                        }
                    };
                }
                return durabilityStrategy;
            }
            return strategy;
        }
        return super.getInvocationStrategy(resource, method, parameters);
    }

    @Override
    protected <R> Invoker<XADataSource, XADataSourceDatabase, XAResource, R, XAException> getInvoker(XAResource object, Method method, Object[] parameters) throws XAException {
        Invoker invoker = super.getInvoker(object, method, parameters);
        Durability.Phase phase = phaseRegistry.get(method);
        if (method.equals(prepareMethod) || endTransactionMethodSet.contains(method)) {
            return this.getDatabaseCluster().getDurability().getInvoker(invoker, phase, parameters[0], this.getExceptionFactory());
        }
        return invoker;
    }

    @Override
    protected void close(XAConnection connection, XAResource resource) {
    }

    @Override
    protected boolean isRecordable(Method method) {
        return databaseWriteMethodSet.contains(method);
    }
}

