/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.state;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.hajdbc.durability.DurabilityListener;
import net.sf.hajdbc.durability.InvocationEvent;
import net.sf.hajdbc.durability.InvokerEvent;
import net.sf.hajdbc.state.SerializedDurabilityListener;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;
import net.sf.hajdbc.util.Objects;

public class DurabilityListenerAdapter
implements DurabilityListener {
    private final ConcurrentMap<Object, byte[]> transactionIdentifiers = new ConcurrentHashMap<Object, byte[]>();
    private final SerializedDurabilityListener listener;
    private final TransactionIdentifierFactory<Object> txIdFactory;

    public DurabilityListenerAdapter(SerializedDurabilityListener listener, TransactionIdentifierFactory<? extends Object> txIdFactory) {
        this.listener = listener;
        this.txIdFactory = txIdFactory;
    }

    @Override
    public void beforeInvocation(InvocationEvent event) {
        Object transactionId = event.getTransactionId();
        byte[] txId = this.txIdFactory.serialize(transactionId);
        this.transactionIdentifiers.put(transactionId, txId);
        this.listener.beforeInvocation(txId, (byte)event.getPhase().ordinal(), (byte)event.getExceptionType().ordinal());
    }

    @Override
    public void afterInvocation(InvocationEvent event) {
        this.listener.afterInvocation((byte[])this.transactionIdentifiers.remove(event.getTransactionId()), (byte)event.getPhase().ordinal());
    }

    @Override
    public void beforeInvoker(InvokerEvent event) {
        this.listener.beforeInvoker((byte[])this.transactionIdentifiers.get(event.getTransactionId()), (byte)event.getPhase().ordinal(), event.getDatabaseId());
    }

    @Override
    public void afterInvoker(InvokerEvent event) {
        this.listener.afterInvoker((byte[])this.transactionIdentifiers.get(event.getTransactionId()), (byte)event.getPhase().ordinal(), event.getDatabaseId(), Objects.serialize(event.getResult()));
    }
}

