/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.state.bdb;

import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.text.MessageFormat;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.pool.generic.GenericObjectPoolConfiguration;
import net.sf.hajdbc.pool.generic.GenericObjectPoolFactory;
import net.sf.hajdbc.state.StateManager;
import net.sf.hajdbc.state.StateManagerFactory;
import net.sf.hajdbc.state.bdb.BerkeleyDBStateManager;
import net.sf.hajdbc.util.Strings;

public class BerkeleyDBStateManagerFactory
extends GenericObjectPoolConfiguration
implements StateManagerFactory {
    private static final long serialVersionUID = 7138340006866127561L;
    private String locationPattern = "{1}/{0}";

    @Override
    public String getId() {
        return "berkeleydb";
    }

    @Override
    public <Z, D extends Database<Z>> StateManager createStateManager(DatabaseCluster<Z, D> cluster) {
        String location = MessageFormat.format(this.locationPattern, cluster.getId(), Strings.HA_JDBC_HOME);
        EnvironmentConfig config = new EnvironmentConfig().setAllowCreate(true).setTransactional(true);
        return new BerkeleyDBStateManager(cluster, new File(location), config, new GenericObjectPoolFactory(this));
    }

    public String getLocationPattern() {
        return this.locationPattern;
    }

    public void setLocationPattern(String pattern) {
        this.locationPattern = pattern;
    }
}

