/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.state.distributed;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.balancer.Balancer;
import net.sf.hajdbc.distributed.CommandDispatcher;
import net.sf.hajdbc.distributed.CommandDispatcherFactory;
import net.sf.hajdbc.distributed.Member;
import net.sf.hajdbc.distributed.MembershipListener;
import net.sf.hajdbc.distributed.Remote;
import net.sf.hajdbc.distributed.Stateful;
import net.sf.hajdbc.durability.InvocationEvent;
import net.sf.hajdbc.durability.InvokerEvent;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.state.DatabaseEvent;
import net.sf.hajdbc.state.StateManager;
import net.sf.hajdbc.state.distributed.ActivationCommand;
import net.sf.hajdbc.state.distributed.DeactivationCommand;
import net.sf.hajdbc.state.distributed.InvokerCommand;
import net.sf.hajdbc.state.distributed.PostInvocationCommand;
import net.sf.hajdbc.state.distributed.PreInvocationCommand;
import net.sf.hajdbc.state.distributed.RemoteInvocationDescriptor;
import net.sf.hajdbc.state.distributed.RemoteInvokerDescriptor;
import net.sf.hajdbc.state.distributed.StateCommandContext;

public class DistributedStateManager<Z, D extends Database<Z>>
implements StateManager,
StateCommandContext<Z, D>,
MembershipListener,
Stateful {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DatabaseCluster<Z, D> cluster;
    private final StateManager stateManager;
    private final CommandDispatcher<StateCommandContext<Z, D>> dispatcher;
    private final ConcurrentMap<Member, Map<InvocationEvent, Map<String, InvokerEvent>>> remoteInvokerMap = new ConcurrentHashMap<Member, Map<InvocationEvent, Map<String, InvokerEvent>>>();

    public DistributedStateManager(DatabaseCluster<Z, D> cluster, CommandDispatcherFactory dispatcherFactory) throws Exception {
        this.cluster = cluster;
        this.stateManager = cluster.getStateManager();
        DistributedStateManager context = this;
        this.dispatcher = dispatcherFactory.createCommandDispatcher(cluster.getId() + ".state", context, this, this);
    }

    @Override
    public Set<String> getActiveDatabases() {
        return this.stateManager.getActiveDatabases();
    }

    @Override
    public void setActiveDatabases(Set<String> databases) {
        this.stateManager.setActiveDatabases(databases);
    }

    @Override
    public void activated(DatabaseEvent event) {
        this.dispatcher.executeAll(new ActivationCommand(event));
    }

    @Override
    public void deactivated(DatabaseEvent event) {
        this.dispatcher.executeAll(new DeactivationCommand(event));
    }

    @Override
    public void afterInvocation(InvocationEvent event) {
        this.dispatcher.executeAll(new PostInvocationCommand(this.getRemoteDescriptor(event)));
        this.stateManager.afterInvocation(event);
    }

    @Override
    public void afterInvoker(InvokerEvent event) {
        this.dispatcher.executeAll(new InvokerCommand(this.getRemoteDescriptor(event)));
        this.stateManager.afterInvoker(event);
    }

    @Override
    public void beforeInvocation(InvocationEvent event) {
        this.stateManager.beforeInvocation(event);
        this.dispatcher.executeAll(new PreInvocationCommand(this.getRemoteDescriptor(event)));
    }

    @Override
    public void beforeInvoker(InvokerEvent event) {
        this.stateManager.beforeInvoker(event);
        this.dispatcher.executeAll(new InvokerCommand(this.getRemoteDescriptor(event)));
    }

    private RemoteInvocationDescriptor getRemoteDescriptor(InvocationEvent event) {
        return new RemoteInvocationDescriptorImpl(event, this.dispatcher.getLocal());
    }

    private RemoteInvokerDescriptor getRemoteDescriptor(InvokerEvent event) {
        return new RemoteInvokerDescriptorImpl(event, this.dispatcher.getLocal());
    }

    @Override
    public void start() throws Exception {
        this.stateManager.start();
        this.dispatcher.start();
    }

    @Override
    public void stop() {
        this.dispatcher.stop();
        this.stateManager.stop();
    }

    @Override
    public boolean isEnabled() {
        return this.stateManager.isEnabled() && this.dispatcher.isCoordinator();
    }

    @Override
    public DatabaseCluster<Z, D> getDatabaseCluster() {
        return this.cluster;
    }

    @Override
    public StateManager getLocalStateManager() {
        return this.stateManager;
    }

    @Override
    public Map<InvocationEvent, Map<String, InvokerEvent>> getRemoteInvokers(Remote remote) {
        return (Map)this.remoteInvokerMap.get(remote.getMember());
    }

    @Override
    public void readState(ObjectInput input) throws IOException, ClassNotFoundException {
        if (input.available() > 0) {
            TreeSet<String> databases = new TreeSet<String>();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                databases.add(input.readUTF());
            }
            this.logger.log(Level.INFO, Messages.INITIAL_CLUSTER_STATE_REMOTE.getMessage(databases, this.dispatcher.getCoordinator()), new Object[0]);
            this.stateManager.setActiveDatabases(databases);
        }
    }

    @Override
    public void writeState(ObjectOutput output) throws IOException {
        Balancer<Z, D> databases = this.cluster.getBalancer();
        output.writeInt(databases.size());
        for (Database database : databases) {
            output.writeUTF(database.getId());
        }
    }

    @Override
    public void added(Member member) {
        this.remoteInvokerMap.putIfAbsent(member, new HashMap());
    }

    @Override
    public void removed(Member member) {
        Map invokers;
        if (this.dispatcher.isCoordinator() && (invokers = (Map)this.remoteInvokerMap.remove(member)) != null) {
            this.cluster.getDurability().recover(invokers);
        }
    }

    @Override
    public Map<InvocationEvent, Map<String, InvokerEvent>> recover() {
        return this.stateManager.recover();
    }

    private static class RemoteInvokerDescriptorImpl
    extends RemoteDescriptor
    implements RemoteInvokerDescriptor {
        private static final long serialVersionUID = 6991831573393882786L;
        private final InvokerEvent event;

        RemoteInvokerDescriptorImpl(InvokerEvent event, Member member) {
            super(member);
            this.event = event;
        }

        @Override
        public InvokerEvent getEvent() {
            return this.event;
        }

        public String toString() {
            return this.event.toString();
        }
    }

    private static class RemoteInvocationDescriptorImpl
    extends RemoteDescriptor
    implements RemoteInvocationDescriptor {
        private static final long serialVersionUID = 7782082258670023082L;
        private final InvocationEvent event;

        RemoteInvocationDescriptorImpl(InvocationEvent event, Member member) {
            super(member);
            this.event = event;
        }

        @Override
        public InvocationEvent getEvent() {
            return this.event;
        }

        public String toString() {
            return this.event.toString();
        }
    }

    private static class RemoteDescriptor
    implements Remote,
    Serializable {
        private static final long serialVersionUID = 3717630867671175936L;
        private final Member member;

        RemoteDescriptor(Member member) {
            this.member = member;
        }

        @Override
        public Member getMember() {
            return this.member;
        }
    }
}

