/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.state.sqlite;

import java.io.File;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.pool.AbstractPoolProvider;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SQLiteDbPoolProvider
extends AbstractPoolProvider<SqlJetDb, SqlJetException> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File file;

    public SQLiteDbPoolProvider(File file) {
        super(SqlJetDb.class, SqlJetException.class);
        this.file = file;
    }

    @Override
    public void close(SqlJetDb database) {
        try {
            database.close();
        }
        catch (SqlJetException e) {
            this.logger.log(Level.WARN, e, e.getMessage(), new Object[0]);
        }
    }

    @Override
    public synchronized SqlJetDb create() throws SqlJetException {
        try {
            boolean exists = this.file.exists();
            SqlJetDb db = SqlJetDb.open((File)this.file, (boolean)true);
            if (!exists) {
                db.getOptions().setAutovacuum(true);
                db.getOptions().setIncrementalVacuum(true);
            }
            return db;
        }
        catch (SqlJetException e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    @Override
    public boolean isValid(SqlJetDb database) {
        return database.isOpen();
    }
}

