/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.state.sqlite;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.durability.Durability;
import net.sf.hajdbc.durability.DurabilityListener;
import net.sf.hajdbc.durability.InvocationEvent;
import net.sf.hajdbc.durability.InvocationEventImpl;
import net.sf.hajdbc.durability.InvokerEvent;
import net.sf.hajdbc.durability.InvokerEventImpl;
import net.sf.hajdbc.durability.InvokerResult;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.pool.Pool;
import net.sf.hajdbc.pool.PoolFactory;
import net.sf.hajdbc.state.DatabaseEvent;
import net.sf.hajdbc.state.DurabilityListenerAdapter;
import net.sf.hajdbc.state.SerializedDurabilityListener;
import net.sf.hajdbc.state.StateManager;
import net.sf.hajdbc.state.sqlite.SQLiteDbPoolProvider;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;
import net.sf.hajdbc.util.Objects;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SQLiteStateManager<Z, D extends Database<Z>>
implements StateManager,
SerializedDurabilityListener {
    private static final Logger logger = LoggerFactory.getLogger(SQLiteStateManager.class);
    private static final String STATE_TABLE = "cluster_state";
    private static final String DATABASE_COLUMN = "database_id";
    private static final String INVOCATION_TABLE = "cluster_invocation";
    private static final String INVOKER_TABLE = "cluster_invoker";
    private static final String INVOKER_TABLE_INDEX = "cluster_invoker_index";
    private static final String TRANSACTION_COLUMN = "tx_id";
    private static final String PHASE_COLUMN = "phase_id";
    private static final String EXCEPTION_COLUMN = "exception_id";
    private static final String RESULT_COLUMN = "result";
    private static final String CREATE_INVOCATION_SQL = MessageFormat.format("CREATE TABLE {0} ({1} BLOB NOT NULL, {2} INTEGER NOT NULL, {3} INTEGER NOT NULL, PRIMARY KEY ({1}, {2}))", "cluster_invocation", "tx_id", "phase_id", "exception_id");
    private static final String CREATE_INVOKER_SQL = MessageFormat.format("CREATE TABLE {0} ({1} BLOB NOT NULL, {2} INTEGER NOT NULL, {3} TEXT NOT NULL, {4} BLOB, PRIMARY KEY ({1}, {2}, {3}))", "cluster_invoker", "tx_id", "phase_id", "database_id", "result");
    private static final String CREATE_INVOKER_INDEX = MessageFormat.format("CREATE INDEX {0} ON {1} ({2}, {3})", "cluster_invoker_index", "cluster_invoker", "tx_id", "phase_id");
    private static final String CREATE_STATE_SQL = MessageFormat.format("CREATE TABLE {0} ({1} TEXT NOT NULL, PRIMARY KEY ({1}))", "cluster_state", "database_id");
    private final DatabaseCluster<Z, D> cluster;
    private final DurabilityListener listener;
    private final File file;
    private final PoolFactory poolFactory;
    private final Map<DB, ReadWriteLock> locks = new EnumMap<DB, ReadWriteLock>(DB.class);
    private final Map<DB, Pool<SqlJetDb, SqlJetException>> pools = new EnumMap<DB, Pool<SqlJetDb, SqlJetException>>(DB.class);

    public SQLiteStateManager(DatabaseCluster<Z, D> cluster, File file, PoolFactory poolFactory) {
        this.cluster = cluster;
        this.file = file;
        this.poolFactory = poolFactory;
        this.listener = new DurabilityListenerAdapter(this, cluster.getTransactionIdentifierFactory());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void activated(final DatabaseEvent event) {
        Transaction transaction = new Transaction(){

            @Override
            public void execute(SqlJetDb db) throws SqlJetException {
                db.getTable(SQLiteStateManager.STATE_TABLE).insert(new Object[]{event.getSource()});
            }
        };
        try {
            this.execute(transaction, DB.STATE);
        }
        catch (SqlJetException e) {
            logger.log(Level.ERROR, e);
        }
    }

    @Override
    public void deactivated(final DatabaseEvent event) {
        Transaction transaction = new Transaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(SqlJetDb db) throws SqlJetException {
                ISqlJetTable table = db.getTable(SQLiteStateManager.STATE_TABLE);
                ISqlJetCursor cursor = table.lookup(table.getPrimaryKeyIndexName(), new Object[]{event.getSource()});
                try {
                    if (!cursor.eof()) {
                        cursor.delete();
                    }
                }
                finally {
                    SQLiteStateManager.close(cursor);
                }
            }
        };
        try {
            this.execute(transaction, DB.STATE);
        }
        catch (SqlJetException e) {
            logger.log(Level.ERROR, e);
        }
    }

    @Override
    public void beforeInvocation(InvocationEvent event) {
        this.listener.beforeInvocation(event);
    }

    @Override
    public void afterInvocation(InvocationEvent event) {
        this.listener.afterInvocation(event);
    }

    @Override
    public void beforeInvoker(InvokerEvent event) {
        this.listener.beforeInvoker(event);
    }

    @Override
    public void afterInvoker(InvokerEvent event) {
        this.listener.afterInvoker(event);
    }

    @Override
    public void start() throws Exception {
        for (DB db : DB.values()) {
            this.locks.put(db, new ReentrantReadWriteLock());
            this.pools.put(db, this.poolFactory.createPool(new SQLiteDbPoolProvider(new File(this.file.toURI().resolve(db.name().toLowerCase())))));
        }
        Transaction stateTransaction = new Transaction(){

            @Override
            public void execute(SqlJetDb database) throws SqlJetException {
                ISqlJetSchema schema = database.getSchema();
                if (schema.getTable(SQLiteStateManager.STATE_TABLE) == null) {
                    database.createTable(CREATE_STATE_SQL);
                } else if (Boolean.getBoolean("ha-jdbc.state.clear")) {
                    database.getTable(SQLiteStateManager.STATE_TABLE).clear();
                }
            }
        };
        Transaction invocationTransaction = new Transaction(){

            @Override
            public void execute(SqlJetDb database) throws SqlJetException {
                ISqlJetSchema schema = database.getSchema();
                if (schema.getTable(SQLiteStateManager.INVOCATION_TABLE) == null) {
                    database.createTable(CREATE_INVOCATION_SQL);
                }
                if (schema.getTable(SQLiteStateManager.INVOKER_TABLE) == null) {
                    database.createTable(CREATE_INVOKER_SQL);
                    database.createIndex(CREATE_INVOKER_INDEX);
                }
            }
        };
        this.execute(stateTransaction, DB.STATE);
        this.execute(invocationTransaction, DB.INVOCATION);
    }

    @Override
    public void stop() {
        for (Pool<SqlJetDb, SqlJetException> pool : this.pools.values()) {
            pool.close();
        }
        this.pools.clear();
    }

    @Override
    public Set<String> getActiveDatabases() {
        Query<Set<String>> query = new Query<Set<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Set<String> execute(SqlJetDb database) throws SqlJetException {
                TreeSet<String> set = new TreeSet<String>();
                ISqlJetTable table = database.getTable(SQLiteStateManager.STATE_TABLE);
                ISqlJetCursor cursor = table.lookup(table.getPrimaryKeyIndexName(), new Object[0]);
                try {
                    if (!cursor.eof()) {
                        do {
                            set.add(cursor.getString(SQLiteStateManager.DATABASE_COLUMN));
                        } while (cursor.next());
                    }
                    TreeSet<String> treeSet = set;
                    return treeSet;
                }
                finally {
                    SQLiteStateManager.close(cursor);
                }
            }
        };
        try {
            return this.execute(query, DB.STATE);
        }
        catch (SqlJetException e) {
            logger.log(Level.ERROR, e);
            return Collections.emptySet();
        }
    }

    @Override
    public void setActiveDatabases(final Set<String> databases) {
        Transaction transaction = new Transaction(){

            @Override
            public void execute(SqlJetDb db) throws SqlJetException {
                ISqlJetTable table = db.getTable(SQLiteStateManager.STATE_TABLE);
                table.clear();
                for (String database : databases) {
                    table.insert(new Object[]{database});
                }
            }
        };
        try {
            this.execute(transaction, DB.STATE);
        }
        catch (SqlJetException e) {
            logger.log(Level.ERROR, e);
        }
    }

    @Override
    public Map<InvocationEvent, Map<String, InvokerEvent>> recover() {
        final TransactionIdentifierFactory<Object> txIdFactory = this.cluster.getTransactionIdentifierFactory();
        Query<Map<InvocationEvent, Map<String, InvokerEvent>>> invocationQuery = new Query<Map<InvocationEvent, Map<String, InvokerEvent>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<InvocationEvent, Map<String, InvokerEvent>> execute(SqlJetDb database) throws SqlJetException {
                Durability.Phase phase;
                Object txId;
                HashMap<InvocationEvent, Map<String, InvokerEvent>> map = new HashMap<InvocationEvent, Map<String, InvokerEvent>>();
                ISqlJetCursor cursor = database.getTable(SQLiteStateManager.INVOCATION_TABLE).open();
                try {
                    if (!cursor.eof()) {
                        do {
                            txId = txIdFactory.deserialize(cursor.getBlobAsArray(SQLiteStateManager.TRANSACTION_COLUMN));
                            phase = Durability.Phase.values()[(int)cursor.getInteger(SQLiteStateManager.PHASE_COLUMN)];
                            ExceptionType type = ExceptionType.values()[(int)cursor.getInteger(SQLiteStateManager.EXCEPTION_COLUMN)];
                            map.put(new InvocationEventImpl(txId, phase, type), new HashMap());
                        } while (cursor.next());
                    }
                }
                finally {
                    cursor.close();
                }
                cursor = database.getTable(SQLiteStateManager.INVOKER_TABLE).open();
                try {
                    if (!cursor.eof()) {
                        do {
                            Map invokers;
                            if ((invokers = (Map)map.get(new InvocationEventImpl(txId = txIdFactory.deserialize(cursor.getBlobAsArray(SQLiteStateManager.TRANSACTION_COLUMN)), phase = Durability.Phase.values()[(int)cursor.getInteger(SQLiteStateManager.PHASE_COLUMN)], null))) == null) continue;
                            String databaseId = cursor.getString(SQLiteStateManager.DATABASE_COLUMN);
                            InvokerEventImpl event = new InvokerEventImpl(txId, phase, databaseId);
                            if (!cursor.isNull(SQLiteStateManager.RESULT_COLUMN)) {
                                byte[] result = cursor.getBlobAsArray(SQLiteStateManager.RESULT_COLUMN);
                                event.setResult((InvokerResult)Objects.deserialize(result));
                            }
                            invokers.put(databaseId, event);
                        } while (cursor.next());
                    }
                }
                finally {
                    cursor.close();
                }
                return map;
            }
        };
        try {
            return this.execute(invocationQuery, DB.INVOCATION);
        }
        catch (SqlJetException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void beforeInvocation(final byte[] transactionId, final byte phase, final byte exceptionType) {
        Transaction transaction = new Transaction(){

            @Override
            public void execute(SqlJetDb db) throws SqlJetException {
                db.getTable(SQLiteStateManager.INVOCATION_TABLE).insert(new Object[]{transactionId, phase, exceptionType});
            }
        };
        try {
            this.execute(transaction, DB.INVOCATION);
        }
        catch (SqlJetException e) {
            logger.log(Level.ERROR, e);
        }
    }

    @Override
    public void afterInvocation(final byte[] transactionId, final byte phase) {
        Transaction transaction = new Transaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(SqlJetDb db) throws SqlJetException {
                ISqlJetTable table = db.getTable(SQLiteStateManager.INVOCATION_TABLE);
                ISqlJetCursor cursor = table.lookup(table.getPrimaryKeyIndexName(), new Object[]{transactionId, phase});
                try {
                    if (!cursor.eof()) {
                        cursor.delete();
                    }
                }
                finally {
                    SQLiteStateManager.close(cursor);
                }
                table = db.getTable(SQLiteStateManager.INVOKER_TABLE);
                cursor = table.lookup(SQLiteStateManager.INVOKER_TABLE_INDEX, new Object[]{transactionId, phase});
                try {
                    if (!cursor.eof()) {
                        do {
                            cursor.delete();
                        } while (cursor.next());
                    }
                }
                finally {
                    SQLiteStateManager.close(cursor);
                }
            }
        };
        try {
            this.execute(transaction, DB.INVOCATION);
        }
        catch (SqlJetException e) {
            logger.log(Level.ERROR, e);
        }
    }

    @Override
    public void beforeInvoker(final byte[] transactionId, final byte phase, final String databaseId) {
        Transaction transaction = new Transaction(){

            @Override
            public void execute(SqlJetDb db) throws SqlJetException {
                db.getTable(SQLiteStateManager.INVOKER_TABLE).insert(new Object[]{transactionId, phase, databaseId});
            }
        };
        try {
            this.execute(transaction, DB.INVOCATION);
        }
        catch (SqlJetException e) {
            logger.log(Level.ERROR, e);
        }
    }

    @Override
    public void afterInvoker(final byte[] transactionId, final byte phase, final String databaseId, final byte[] result) {
        Transaction transaction = new Transaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(SqlJetDb db) throws SqlJetException {
                ISqlJetTable table = db.getTable(SQLiteStateManager.INVOKER_TABLE);
                ISqlJetCursor cursor = table.lookup(table.getPrimaryKeyIndexName(), new Object[]{transactionId, phase, databaseId});
                try {
                    if (!cursor.eof()) {
                        cursor.updateByFieldNames(Collections.singletonMap(SQLiteStateManager.RESULT_COLUMN, result));
                    }
                }
                finally {
                    SQLiteStateManager.close(cursor);
                }
            }
        };
        try {
            this.execute(transaction, DB.INVOCATION);
        }
        catch (SqlJetException e) {
            logger.log(Level.ERROR, e);
        }
    }

    static void close(ISqlJetCursor cursor) {
        try {
            cursor.close();
        }
        catch (SqlJetException e) {
            logger.log(Level.WARN, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Transaction transaction, DB db) throws SqlJetException {
        Pool<SqlJetDb, SqlJetException> pool = this.pools.get((Object)db);
        Lock lock = this.locks.get((Object)db).writeLock();
        SqlJetDb database = pool.take();
        lock.lock();
        try {
            database.beginTransaction(SqlJetTransactionMode.WRITE);
            try {
                transaction.execute(database);
                database.commit();
            }
            catch (SqlJetException e) {
                try {
                    database.rollback();
                }
                catch (SqlJetException ex) {
                    logger.log(Level.WARN, ex);
                }
                throw e;
            }
        }
        finally {
            lock.unlock();
            pool.release(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(Query<T> query, DB db) throws SqlJetException {
        Pool<SqlJetDb, SqlJetException> pool = this.pools.get((Object)db);
        Lock lock = this.locks.get((Object)db).readLock();
        SqlJetDb database = pool.take();
        lock.lock();
        try {
            T t;
            database.beginTransaction(SqlJetTransactionMode.READ_ONLY);
            try {
                t = query.execute(database);
            }
            catch (Throwable throwable) {
                database.commit();
                throw throwable;
            }
            database.commit();
            return t;
        }
        finally {
            lock.unlock();
            pool.release(database);
        }
    }

    static interface Transaction {
        public void execute(SqlJetDb var1) throws SqlJetException;
    }

    static interface Query<T> {
        public T execute(SqlJetDb var1) throws SqlJetException;
    }

    private static enum DB {
        STATE,
        INVOCATION;

    }
}

