/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sync;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.QualifiedName;
import net.sf.hajdbc.SynchronizationStrategy;
import net.sf.hajdbc.TableProperties;
import net.sf.hajdbc.UniqueConstraint;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.sync.PerTableSynchronizationStrategy;
import net.sf.hajdbc.sync.SynchronizationContext;
import net.sf.hajdbc.sync.SynchronizationSupport;
import net.sf.hajdbc.sync.TableSynchronizationStrategy;
import net.sf.hajdbc.util.Objects;
import net.sf.hajdbc.util.Resources;
import net.sf.hajdbc.util.Strings;

public class DifferentialSynchronizationStrategy
implements SynchronizationStrategy,
TableSynchronizationStrategy,
Serializable {
    private static final long serialVersionUID = -2785092229503649831L;
    private static Logger logger = LoggerFactory.getLogger(DifferentialSynchronizationStrategy.class);
    private final SynchronizationStrategy strategy = new PerTableSynchronizationStrategy(this);
    private int fetchSize = 0;
    private int maxBatchSize = 100;
    private Pattern versionPattern = null;

    @Override
    public String getId() {
        return "diff";
    }

    @Override
    public <Z, D extends Database<Z>> void synchronize(SynchronizationContext<Z, D> context) throws SQLException {
        this.strategy.synchronize(context);
    }

    @Override
    public <Z, D extends Database<Z>> void init(DatabaseCluster<Z, D> cluster) {
        this.strategy.init(cluster);
    }

    @Override
    public <Z, D extends Database<Z>> void destroy(DatabaseCluster<Z, D> cluster) {
        this.strategy.destroy(cluster);
    }

    @Override
    public <Z, D extends Database<Z>> void dropConstraints(SynchronizationContext<Z, D> context) throws SQLException {
        SynchronizationSupport support = context.getSynchronizationSupport();
        support.dropForeignKeys();
        support.dropUniqueConstraints();
    }

    @Override
    public <Z, D extends Database<Z>> void restoreConstraints(SynchronizationContext<Z, D> context) throws SQLException {
        SynchronizationSupport support = context.getSynchronizationSupport();
        support.restoreUniqueConstraints();
        support.restoreForeignKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <Z, D extends Database<Z>> void synchronize(SynchronizationContext<Z, D> context, TableProperties table) throws SQLException {
        String tableName = ((QualifiedName)table.getName()).getDMLName();
        UniqueConstraint primaryKey = table.getPrimaryKey();
        if (primaryKey == null) {
            throw new SQLException(Messages.PRIMARY_KEY_REQUIRED.getMessage(this.getClass().getName(), tableName));
        }
        List<String> primaryKeyColumns = primaryKey.getColumnList();
        Collection<String> columns = table.getColumns();
        ArrayList<String> nonPrimaryKeyColumns = new ArrayList<String>(columns.size());
        ArrayList<String> versionColumns = new ArrayList<String>(columns.size());
        for (String column : columns) {
            if (primaryKeyColumns.contains(column)) continue;
            if (this.versionPattern != null && this.versionPattern.matcher(column).matches()) {
                versionColumns.add(column);
            }
            nonPrimaryKeyColumns.add(column);
        }
        ArrayList<String> allColumns = new ArrayList<String>(columns.size());
        allColumns.addAll(primaryKeyColumns);
        allColumns.addAll(nonPrimaryKeyColumns);
        ArrayList<String> selectColumns = allColumns;
        if (!versionColumns.isEmpty()) {
            selectColumns = new ArrayList(primaryKeyColumns.size() + versionColumns.size());
            selectColumns.addAll(primaryKeyColumns);
            selectColumns.addAll(versionColumns);
        }
        final String selectSQL = String.format("SELECT %s FROM %s ORDER BY %s", Strings.join(selectColumns, ", "), tableName, Strings.join(primaryKeyColumns, ", "));
        String primaryKeyWhereClause = Strings.join(new StringBuilder(), primaryKeyColumns, " = ? AND ").append(" = ?").toString();
        String selectAllSQL = !versionColumns.isEmpty() ? String.format("SELECT %s FROM %s WHERE %s", Strings.join(nonPrimaryKeyColumns, ", "), tableName, primaryKeyWhereClause) : null;
        String deleteSQL = String.format("DELETE FROM %s WHERE %s", tableName, primaryKeyWhereClause);
        String insertSQL = String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, Strings.join(allColumns, ", "), Strings.join(Collections.nCopies(allColumns.size(), "?"), ", "));
        String updateSQL = !nonPrimaryKeyColumns.isEmpty() ? String.format("UPDATE %s SET %s = ? WHERE %s", tableName, Strings.join(nonPrimaryKeyColumns, " = ?, "), primaryKeyWhereClause) : null;
        Connection targetConnection = context.getConnection(context.getTargetDatabase());
        final Statement targetStatement = targetConnection.createStatement();
        try {
            targetStatement.setFetchSize(this.fetchSize);
            Callable<ResultSet> callable = new Callable<ResultSet>(){

                @Override
                public ResultSet call() throws SQLException {
                    logger.log(Level.DEBUG, selectSQL, new Object[0]);
                    return targetStatement.executeQuery(selectSQL);
                }
            };
            Future<ResultSet> future = context.getExecutor().submit(callable);
            Connection sourceConnection = context.getConnection(context.getSourceDatabase());
            Statement sourceStatement = sourceConnection.createStatement();
            try {
                sourceStatement.setFetchSize(this.fetchSize);
                ResultSet sourceResultSet = sourceStatement.executeQuery(selectSQL);
                ResultSet targetResultSet = future.get();
                PreparedStatement selectAllStatement = null;
                if (!versionColumns.isEmpty()) {
                    logger.log(Level.DEBUG, selectAllSQL, new Object[0]);
                    selectAllStatement = targetConnection.prepareStatement(selectAllSQL);
                }
                try {
                    block61: {
                        logger.log(Level.DEBUG, deleteSQL, new Object[0]);
                        PreparedStatement deleteStatement = targetConnection.prepareStatement(deleteSQL);
                        try {
                            logger.log(Level.DEBUG, insertSQL, new Object[0]);
                            PreparedStatement insertStatement = targetConnection.prepareStatement(insertSQL);
                            try {
                                PreparedStatement updateStatement = null;
                                if (!nonPrimaryKeyColumns.isEmpty()) {
                                    logger.log(Level.DEBUG, updateSQL, new Object[0]);
                                    updateStatement = targetConnection.prepareStatement(updateSQL);
                                }
                                try {
                                    boolean hasMoreSourceResults = sourceResultSet.next();
                                    boolean hasMoreTargetResults = targetResultSet.next();
                                    int insertCount = 0;
                                    int updateCount = 0;
                                    int deleteCount = 0;
                                    while (hasMoreSourceResults || hasMoreTargetResults) {
                                        int i;
                                        int compare = 0;
                                        if (!hasMoreSourceResults) {
                                            compare = 1;
                                        } else if (!hasMoreTargetResults) {
                                            compare = -1;
                                        } else {
                                            Object targetObject;
                                            Object sourceObject;
                                            for (i = 1; i <= primaryKeyColumns.size() && (compare = this.compare(sourceObject = sourceResultSet.getObject(i), targetObject = targetResultSet.getObject(i))) == 0; ++i) {
                                            }
                                        }
                                        if (compare > 0) {
                                            deleteStatement.clearParameters();
                                            for (i = 1; i <= primaryKeyColumns.size(); ++i) {
                                                int type = context.getDialect().getColumnType(table.getColumnProperties((String)allColumns.get(i - 1)));
                                                deleteStatement.setObject(i, targetResultSet.getObject(i), type);
                                            }
                                            deleteStatement.addBatch();
                                            if (++deleteCount % this.maxBatchSize == 0) {
                                                deleteStatement.executeBatch();
                                                deleteStatement.clearBatch();
                                            }
                                        } else if (compare < 0) {
                                            insertStatement.clearParameters();
                                            for (i = 1; i <= primaryKeyColumns.size(); ++i) {
                                                int type = context.getDialect().getColumnType(table.getColumnProperties((String)allColumns.get(i - 1)));
                                                insertStatement.setObject(i, sourceResultSet.getObject(i), type);
                                            }
                                            if (versionColumns.isEmpty()) {
                                                for (i = primaryKeyColumns.size() + 1; i <= allColumns.size(); ++i) {
                                                    int type = context.getDialect().getColumnType(table.getColumnProperties((String)allColumns.get(i - 1)));
                                                    Object object = context.getSynchronizationSupport().getObject(sourceResultSet, i, type);
                                                    if (sourceResultSet.wasNull()) {
                                                        insertStatement.setNull(i, type);
                                                        continue;
                                                    }
                                                    insertStatement.setObject(i, object, type);
                                                }
                                            } else if (selectAllStatement != null) {
                                                selectAllStatement.clearParameters();
                                                for (i = 1; i <= primaryKeyColumns.size(); ++i) {
                                                    int type = context.getDialect().getColumnType(table.getColumnProperties((String)allColumns.get(i - 1)));
                                                    selectAllStatement.setObject(i, sourceResultSet.getObject(i), type);
                                                }
                                                ResultSet selectAllResultSet = selectAllStatement.executeQuery();
                                                for (int i2 = primaryKeyColumns.size() + 1; i2 <= allColumns.size(); ++i2) {
                                                    int type = context.getDialect().getColumnType(table.getColumnProperties((String)allColumns.get(i2 - 1)));
                                                    Object object = context.getSynchronizationSupport().getObject(selectAllResultSet, i2 - primaryKeyColumns.size(), type);
                                                    if (selectAllResultSet.wasNull()) {
                                                        insertStatement.setNull(i2, type);
                                                        continue;
                                                    }
                                                    insertStatement.setObject(i2, object, type);
                                                }
                                            }
                                            insertStatement.addBatch();
                                            if (++insertCount % this.maxBatchSize == 0) {
                                                insertStatement.executeBatch();
                                                insertStatement.clearBatch();
                                            }
                                        } else if (updateStatement != null) {
                                            int i3;
                                            updateStatement.clearParameters();
                                            boolean updated = false;
                                            for (i3 = primaryKeyColumns.size() + 1; i3 <= selectColumns.size(); ++i3) {
                                                int type = context.getDialect().getColumnType(table.getColumnProperties((String)selectColumns.get(i3 - 1)));
                                                Object sourceObject = context.getSynchronizationSupport().getObject(sourceResultSet, i3, type);
                                                Object targetObject = context.getSynchronizationSupport().getObject(targetResultSet, i3, type);
                                                int index = i3 - primaryKeyColumns.size();
                                                if (sourceResultSet.wasNull()) {
                                                    updateStatement.setNull(index, type);
                                                    updated |= !targetResultSet.wasNull();
                                                    continue;
                                                }
                                                updateStatement.setObject(index, sourceObject, type);
                                                updated |= targetResultSet.wasNull();
                                                updated |= !Objects.equals(sourceObject, targetObject);
                                            }
                                            if (updated) {
                                                if (selectAllStatement != null) {
                                                    selectAllStatement.clearParameters();
                                                    for (i3 = 1; i3 <= primaryKeyColumns.size(); ++i3) {
                                                        int type = context.getDialect().getColumnType(table.getColumnProperties((String)allColumns.get(i3 - 1)));
                                                        selectAllStatement.setObject(i3, sourceResultSet.getObject(i3), type);
                                                    }
                                                    ResultSet selectAllResultSet = selectAllStatement.executeQuery();
                                                    for (int i4 = primaryKeyColumns.size() + 1; i4 <= allColumns.size(); ++i4) {
                                                        int type = context.getDialect().getColumnType(table.getColumnProperties((String)allColumns.get(i4 - 1)));
                                                        int index = i4 - primaryKeyColumns.size();
                                                        Object object = context.getSynchronizationSupport().getObject(selectAllResultSet, index, type);
                                                        if (selectAllResultSet.wasNull()) {
                                                            updateStatement.setNull(index, type);
                                                            continue;
                                                        }
                                                        updateStatement.setObject(index, object, type);
                                                    }
                                                }
                                                for (int i5 = 1; i5 <= primaryKeyColumns.size(); ++i5) {
                                                    int type = context.getDialect().getColumnType(table.getColumnProperties((String)allColumns.get(i5 - 1)));
                                                    updateStatement.setObject(i5 + nonPrimaryKeyColumns.size(), targetResultSet.getObject(i5), type);
                                                }
                                                updateStatement.addBatch();
                                                if (++updateCount % this.maxBatchSize == 0) {
                                                    updateStatement.executeBatch();
                                                    updateStatement.clearBatch();
                                                }
                                            }
                                        }
                                        if (hasMoreSourceResults && compare <= 0) {
                                            hasMoreSourceResults = sourceResultSet.next();
                                        }
                                        if (!hasMoreTargetResults || compare < 0) continue;
                                        hasMoreTargetResults = targetResultSet.next();
                                    }
                                    if (deleteCount % this.maxBatchSize > 0) {
                                        deleteStatement.executeBatch();
                                    }
                                    if (insertCount % this.maxBatchSize > 0) {
                                        insertStatement.executeBatch();
                                    }
                                    if (updateStatement != null && updateCount % this.maxBatchSize > 0) {
                                        updateStatement.executeBatch();
                                    }
                                    logger.log(Level.INFO, Messages.INSERT_COUNT.getMessage(new Object[0]), insertCount, tableName);
                                    logger.log(Level.INFO, Messages.UPDATE_COUNT.getMessage(new Object[0]), updateCount, tableName);
                                    logger.log(Level.INFO, Messages.DELETE_COUNT.getMessage(new Object[0]), deleteCount, tableName);
                                    if (updateStatement == null) break block61;
                                }
                                catch (Throwable throwable) {
                                    if (updateStatement == null) throw throwable;
                                    Resources.close(updateStatement);
                                    throw throwable;
                                }
                                Resources.close(updateStatement);
                            }
                            finally {
                                Resources.close(insertStatement);
                            }
                        }
                        finally {
                            Resources.close(deleteStatement);
                        }
                    }
                    if (selectAllStatement == null) return;
                }
                catch (Throwable throwable) {
                    if (selectAllStatement == null) throw throwable;
                    Resources.close(selectAllStatement);
                    throw throwable;
                }
                Resources.close(selectAllStatement);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(e);
            }
            catch (ExecutionException e) {
                throw ExceptionType.getExceptionFactory(SQLException.class).createException(e.getCause());
            }
            finally {
                Resources.close(sourceStatement);
            }
        }
        finally {
            Resources.close(targetStatement);
        }
    }

    private int compare(Object object1, Object object2) {
        Comparable comparable = (Comparable)object1;
        return comparable.compareTo(object2);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public String getVersionPattern() {
        return this.versionPattern != null ? this.versionPattern.pattern() : null;
    }

    public void setVersionPattern(String versionPattern) {
        this.versionPattern = versionPattern != null ? Pattern.compile(versionPattern, 2) : null;
    }
}

