/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.security.PrivilegedExceptionAction;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import net.sf.hajdbc.ConnectionProperties;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DumpRestoreSupport;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.SynchronizationStrategy;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.sync.SynchronizationContext;
import net.sf.hajdbc.util.Files;
import net.sf.hajdbc.util.Security;
import net.sf.hajdbc.util.Strings;

public class DumpRestoreSynchronizationStrategy
implements SynchronizationStrategy {
    private static final long serialVersionUID = 5743532034969216540L;
    private static final String DUMP_FILE_SUFFIX = ".dump";

    @Override
    public String getId() {
        return "dump-restore";
    }

    @Override
    public <Z, D extends Database<Z>> void init(DatabaseCluster<Z, D> cluster) {
    }

    @Override
    public <Z, D extends Database<Z>> void destroy(DatabaseCluster<Z, D> cluster) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Z, D extends Database<Z>> void synchronize(SynchronizationContext<Z, D> context) throws SQLException {
        Dialect dialect = context.getDialect();
        DumpRestoreSupport support = dialect.getDumpRestoreSupport();
        if (support == null) {
            throw new SQLException(Messages.DUMP_RESTORE_UNSUPPORTED.getMessage(dialect));
        }
        try {
            File file = Files.createTempFile(DUMP_FILE_SUFFIX);
            try {
                this.startProcess(support.createDumpProcess(new ConnectionPropertiesImpl<Z, D>(context, context.getSourceDatabase()), file));
                this.startProcess(support.createRestoreProcess(new ConnectionPropertiesImpl<Z, D>(context, context.getTargetDatabase()), file));
            }
            finally {
                Files.delete(file);
            }
        }
        catch (Exception e) {
            throw ExceptionType.getExceptionFactory(SQLException.class).createException(e);
        }
    }

    private void startProcess(final ProcessBuilder processBuilder) throws Exception {
        PrivilegedExceptionAction<Process> action = new PrivilegedExceptionAction<Process>(){

            @Override
            public Process run() throws Exception {
                return processBuilder.start();
            }
        };
        Process process = Security.run(action);
        try {
            int status = process.waitFor();
            if (status != 0) {
                StringBuilder builder = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String line = reader.readLine();
                while (line != null) {
                    builder.append(line).append(Strings.NEW_LINE);
                    line = reader.readLine();
                }
                throw new Exception(builder.toString());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new Exception(processBuilder.toString(), e);
        }
    }

    private static class ConnectionPropertiesImpl<Z, D extends Database<Z>>
    implements ConnectionProperties {
        private final String host;
        private final String port;
        private final String database;
        private final String user;
        private final String password;

        ConnectionPropertiesImpl(SynchronizationContext<Z, D> context, D database) throws SQLException {
            DatabaseMetaData metaData = context.getConnection(database).getMetaData();
            String url = metaData.getURL();
            if (url == null) {
                throw new UnsupportedOperationException();
            }
            Matcher matcher = context.getDialect().getUrlPattern().matcher(url);
            if (!matcher.find() || matcher.groupCount() != 3) {
                throw new UnsupportedOperationException(url);
            }
            this.host = matcher.group(1);
            this.port = matcher.group(2);
            this.database = matcher.group(3);
            this.user = metaData.getUserName();
            this.password = database.decodePassword(context.getDecoder());
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public String getPort() {
            return this.port;
        }

        @Override
        public String getDatabase() {
            return this.database;
        }

        @Override
        public String getUser() {
            return this.user;
        }

        @Override
        public String getPassword() {
            return this.password;
        }
    }
}

