/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sync;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.QualifiedName;
import net.sf.hajdbc.SynchronizationStrategy;
import net.sf.hajdbc.TableProperties;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.sync.PerTableSynchronizationStrategy;
import net.sf.hajdbc.sync.SynchronizationContext;
import net.sf.hajdbc.sync.TableSynchronizationStrategy;
import net.sf.hajdbc.util.Resources;
import net.sf.hajdbc.util.Strings;

public class FullSynchronizationStrategy
implements SynchronizationStrategy,
TableSynchronizationStrategy,
Serializable {
    private static final long serialVersionUID = 9190347092842178162L;
    private static Logger logger = LoggerFactory.getLogger(FullSynchronizationStrategy.class);
    private SynchronizationStrategy strategy = new PerTableSynchronizationStrategy(this);
    private int maxBatchSize = 100;
    private int fetchSize = 0;

    @Override
    public String getId() {
        return "full";
    }

    @Override
    public <Z, D extends Database<Z>> void init(DatabaseCluster<Z, D> cluster) {
        this.strategy.init(cluster);
    }

    @Override
    public <Z, D extends Database<Z>> void synchronize(SynchronizationContext<Z, D> context) throws SQLException {
        this.strategy.synchronize(context);
    }

    @Override
    public <Z, D extends Database<Z>> void destroy(DatabaseCluster<Z, D> cluster) {
        this.strategy.destroy(cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Z, D extends Database<Z>> void synchronize(SynchronizationContext<Z, D> context, TableProperties table) throws SQLException {
        String tableName = ((QualifiedName)table.getName()).getDMLName();
        Collection<String> columns = table.getColumns();
        String commaDelimitedColumns = Strings.join(columns, ", ");
        final String selectSQL = String.format("SELECT %s FROM %s", commaDelimitedColumns, tableName);
        String deleteSQL = context.getDialect().getTruncateTableSQL(table);
        String insertSQL = String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, commaDelimitedColumns, Strings.join(Collections.nCopies(columns.size(), "?"), ", "));
        Connection sourceConnection = context.getConnection(context.getSourceDatabase());
        final Statement selectStatement = sourceConnection.createStatement();
        try {
            selectStatement.setFetchSize(this.fetchSize);
            Callable<ResultSet> callable = new Callable<ResultSet>(){

                @Override
                public ResultSet call() throws SQLException {
                    logger.log(Level.DEBUG, selectSQL, new Object[0]);
                    return selectStatement.executeQuery(selectSQL);
                }
            };
            Future<ResultSet> future = context.getExecutor().submit(callable);
            Connection targetConnection = context.getConnection(context.getTargetDatabase());
            Statement deleteStatement = targetConnection.createStatement();
            try {
                logger.log(Level.DEBUG, deleteSQL, new Object[0]);
                int deletedRows = deleteStatement.executeUpdate(deleteSQL);
                logger.log(Level.INFO, Messages.DELETE_COUNT.getMessage(new Object[0]), deletedRows, tableName);
            }
            finally {
                Resources.close(deleteStatement);
            }
            logger.log(Level.DEBUG, insertSQL, new Object[0]);
            PreparedStatement insertStatement = targetConnection.prepareStatement(insertSQL);
            try {
                int statementCount = 0;
                ResultSet resultSet = future.get();
                while (resultSet.next()) {
                    int index = 0;
                    for (String column : table.getColumns()) {
                        int type = context.getDialect().getColumnType(table.getColumnProperties(column));
                        Object object = context.getSynchronizationSupport().getObject(resultSet, ++index, type);
                        if (resultSet.wasNull()) {
                            insertStatement.setNull(index, type);
                            continue;
                        }
                        insertStatement.setObject(index, object, type);
                    }
                    insertStatement.addBatch();
                    if (++statementCount % this.maxBatchSize == 0) {
                        insertStatement.executeBatch();
                        insertStatement.clearBatch();
                    }
                    insertStatement.clearParameters();
                }
                if (statementCount % this.maxBatchSize > 0) {
                    insertStatement.executeBatch();
                }
                logger.log(Level.INFO, Messages.INSERT_COUNT.getMessage(new Object[0]), statementCount, table);
            }
            catch (ExecutionException e) {
                throw ExceptionType.getExceptionFactory(SQLException.class).createException(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(e);
            }
            finally {
                Resources.close(insertStatement);
            }
        }
        finally {
            Resources.close(selectStatement);
        }
    }

    @Override
    public <Z, D extends Database<Z>> void dropConstraints(SynchronizationContext<Z, D> context) throws SQLException {
        context.getSynchronizationSupport().dropForeignKeys();
    }

    @Override
    public <Z, D extends Database<Z>> void restoreConstraints(SynchronizationContext<Z, D> context) throws SQLException {
        context.getSynchronizationSupport().restoreForeignKeys();
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }
}

