/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sync;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.DatabaseCluster;
import net.sf.hajdbc.DatabaseProperties;
import net.sf.hajdbc.balancer.Balancer;
import net.sf.hajdbc.cache.DatabaseMetaDataCache;
import net.sf.hajdbc.codec.Decoder;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.sync.SynchronizationContext;
import net.sf.hajdbc.sync.SynchronizationSupport;
import net.sf.hajdbc.sync.SynchronizationSupportImpl;
import net.sf.hajdbc.util.Resources;

public class SynchronizationContextImpl<Z, D extends Database<Z>>
implements SynchronizationContext<Z, D> {
    private static final Logger logger = LoggerFactory.getLogger(SynchronizationContextImpl.class);
    private final Set<D> activeDatabaseSet;
    private final D sourceDatabase;
    private final D targetDatabase;
    private final DatabaseCluster<Z, D> cluster;
    private final DatabaseProperties sourceDatabaseProperties;
    private final DatabaseProperties targetDatabaseProperties;
    private final Map<D, Map.Entry<Connection, Boolean>> connectionMap = new HashMap<D, Map.Entry<Connection, Boolean>>();
    private final ExecutorService executor;

    public SynchronizationContextImpl(DatabaseCluster<Z, D> cluster, D database) throws SQLException {
        this.cluster = cluster;
        Balancer<Z, D> balancer = cluster.getBalancer();
        this.sourceDatabase = balancer.next();
        this.activeDatabaseSet = balancer;
        this.targetDatabase = database;
        this.executor = Executors.newFixedThreadPool(this.activeDatabaseSet.size(), this.cluster.getThreadFactory());
        DatabaseMetaDataCache<Z, D> cache = cluster.getDatabaseMetaDataCache();
        this.targetDatabaseProperties = cache.getDatabaseProperties(this.targetDatabase, this.getConnection(this.targetDatabase));
        this.sourceDatabaseProperties = cache.getDatabaseProperties(this.sourceDatabase, this.getConnection(this.sourceDatabase));
    }

    @Override
    public Connection getConnection(D database) throws SQLException {
        Map.Entry<Connection, Boolean> entry = this.connectionMap.get(database);
        if (entry == null) {
            Connection connection = database.connect(database.createConnectionSource(), database.decodePassword(this.cluster.getDecoder()));
            entry = new AbstractMap.SimpleImmutableEntry<Connection, Boolean>(connection, connection.getAutoCommit());
            this.connectionMap.put(database, entry);
        }
        return entry.getKey();
    }

    @Override
    public D getSourceDatabase() {
        return this.sourceDatabase;
    }

    @Override
    public D getTargetDatabase() {
        return this.targetDatabase;
    }

    @Override
    public Set<D> getActiveDatabaseSet() {
        return this.activeDatabaseSet;
    }

    @Override
    public DatabaseProperties getSourceDatabaseProperties() {
        return this.sourceDatabaseProperties;
    }

    @Override
    public DatabaseProperties getTargetDatabaseProperties() {
        return this.targetDatabaseProperties;
    }

    @Override
    public Dialect getDialect() {
        return this.cluster.getDialect();
    }

    @Override
    public Decoder getDecoder() {
        return this.cluster.getDecoder();
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public SynchronizationSupport getSynchronizationSupport() {
        return new SynchronizationSupportImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        for (Map.Entry<Connection, Boolean> entry : this.connectionMap.values()) {
            Connection connection = entry.getKey();
            try {
                connection.setAutoCommit(entry.getValue());
            }
            catch (SQLException e) {
                logger.log(Level.WARN, e);
            }
            finally {
                Resources.close(connection);
            }
        }
        this.executor.shutdown();
    }
}

