/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.sync;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.sf.hajdbc.Database;
import net.sf.hajdbc.ExceptionType;
import net.sf.hajdbc.ForeignKeyConstraint;
import net.sf.hajdbc.IdentityColumnSupport;
import net.sf.hajdbc.Messages;
import net.sf.hajdbc.SequenceProperties;
import net.sf.hajdbc.SequenceSupport;
import net.sf.hajdbc.TableProperties;
import net.sf.hajdbc.UniqueConstraint;
import net.sf.hajdbc.dialect.Dialect;
import net.sf.hajdbc.logging.Level;
import net.sf.hajdbc.logging.Logger;
import net.sf.hajdbc.logging.LoggerFactory;
import net.sf.hajdbc.sync.SynchronizationContext;
import net.sf.hajdbc.sync.SynchronizationSupport;
import net.sf.hajdbc.util.Resources;
import net.sf.hajdbc.util.Strings;

public class SynchronizationSupportImpl<Z, D extends Database<Z>>
implements SynchronizationSupport {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SynchronizationContext<Z, D> context;

    public SynchronizationSupportImpl(SynchronizationContext<Z, D> context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropForeignKeys() throws SQLException {
        Dialect dialect = this.context.getDialect();
        Connection connection = this.context.getConnection(this.context.getTargetDatabase());
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            try {
                for (TableProperties table : this.context.getTargetDatabaseProperties().getTables()) {
                    for (ForeignKeyConstraint constraint : table.getForeignKeyConstraints()) {
                        String sql = dialect.getDropForeignKeyConstraintSQL(constraint);
                        this.logger.log(Level.DEBUG, sql, new Object[0]);
                        statement.addBatch(sql);
                    }
                }
                statement.executeBatch();
            }
            finally {
                Resources.close(statement);
            }
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreForeignKeys() throws SQLException {
        Dialect dialect = this.context.getDialect();
        Connection connection = this.context.getConnection(this.context.getTargetDatabase());
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            try {
                for (TableProperties table : this.context.getSourceDatabaseProperties().getTables()) {
                    for (ForeignKeyConstraint constraint : table.getForeignKeyConstraints()) {
                        String sql = dialect.getCreateForeignKeyConstraintSQL(constraint);
                        this.logger.log(Level.DEBUG, sql, new Object[0]);
                        statement.addBatch(sql);
                    }
                }
                statement.executeBatch();
            }
            finally {
                Resources.close(statement);
            }
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeSequences() throws SQLException {
        Collection<SequenceProperties> sequences;
        SequenceSupport support = this.context.getDialect().getSequenceSupport();
        if (support != null && !(sequences = this.context.getSourceDatabaseProperties().getSequences()).isEmpty()) {
            D sourceDatabase = this.context.getSourceDatabase();
            Set<D> databases = this.context.getActiveDatabaseSet();
            ExecutorService executor = this.context.getExecutor();
            HashMap<SequenceProperties, Long> sequenceMap = new HashMap<SequenceProperties, Long>();
            HashMap<Database, Future<Long>> futureMap = new HashMap<Database, Future<Long>>();
            for (SequenceProperties sequence : sequences) {
                final String sql = support.getNextSequenceValueSQL(sequence);
                this.logger.log(Level.DEBUG, sql, new Object[0]);
                for (final Database database : databases) {
                    final SynchronizationContext<Z, D> context = this.context;
                    Callable<Long> task = new Callable<Long>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Long call() throws SQLException {
                            Statement statement = context.getConnection(database).createStatement();
                            try {
                                ResultSet resultSet = statement.executeQuery(sql);
                                resultSet.next();
                                Long l = resultSet.getLong(1);
                                return l;
                            }
                            finally {
                                Resources.close(statement);
                            }
                        }
                    };
                    futureMap.put(database, executor.submit(task));
                }
                try {
                    Long sourceValue = (Long)((Future)futureMap.get(sourceDatabase)).get();
                    sequenceMap.put(sequence, sourceValue);
                    for (Database database : databases) {
                        Long value;
                        if (database.equals(sourceDatabase) || (value = (Long)((Future)futureMap.get(database)).get()).equals(sourceValue)) continue;
                        throw new SQLException(Messages.SEQUENCE_OUT_OF_SYNC.getMessage(sequence, database, value, sourceDatabase, sourceValue));
                    }
                }
                catch (InterruptedException e) {
                    throw new SQLException(e);
                }
                catch (ExecutionException e) {
                    throw ExceptionType.getExceptionFactory(SQLException.class).createException(e.getCause());
                }
            }
            Connection targetConnection = this.context.getConnection(this.context.getTargetDatabase());
            Statement targetStatement = targetConnection.createStatement();
            try {
                for (SequenceProperties sequence : sequences) {
                    String sql = support.getAlterSequenceSQL(sequence, (Long)sequenceMap.get(sequence) + 1L);
                    this.logger.log(Level.DEBUG, sql, new Object[0]);
                    targetStatement.addBatch(sql);
                }
                targetStatement.executeBatch();
            }
            finally {
                Resources.close(targetStatement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeIdentityColumns() throws SQLException {
        IdentityColumnSupport support = this.context.getDialect().getIdentityColumnSupport();
        if (support != null) {
            Statement sourceStatement = this.context.getConnection(this.context.getSourceDatabase()).createStatement();
            try {
                Statement targetStatement = this.context.getConnection(this.context.getTargetDatabase()).createStatement();
                try {
                    for (TableProperties table : this.context.getSourceDatabaseProperties().getTables()) {
                        Collection<String> columns = table.getIdentityColumns();
                        if (columns.isEmpty()) continue;
                        String selectSQL = MessageFormat.format("SELECT max({0}) FROM {1}", Strings.join(columns, "), max("), table.getName());
                        this.logger.log(Level.DEBUG, selectSQL, new Object[0]);
                        HashMap<String, Long> map = new HashMap<String, Long>();
                        ResultSet resultSet = sourceStatement.executeQuery(selectSQL);
                        try {
                            if (resultSet.next()) {
                                int i = 0;
                                for (String column : columns) {
                                    map.put(column, resultSet.getLong(++i));
                                }
                            }
                        }
                        finally {
                            Resources.close(resultSet);
                        }
                        if (map.isEmpty()) continue;
                        for (Map.Entry mapEntry : map.entrySet()) {
                            String alterSQL = support.getAlterIdentityColumnSQL(table, table.getColumnProperties((String)mapEntry.getKey()), (Long)mapEntry.getValue() + 1L);
                            if (alterSQL == null) continue;
                            this.logger.log(Level.DEBUG, alterSQL, new Object[0]);
                            targetStatement.addBatch(alterSQL);
                        }
                        targetStatement.executeBatch();
                    }
                }
                finally {
                    Resources.close(targetStatement);
                }
            }
            finally {
                Resources.close(sourceStatement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropUniqueConstraints() throws SQLException {
        Dialect dialect = this.context.getDialect();
        Connection connection = this.context.getConnection(this.context.getTargetDatabase());
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            try {
                for (TableProperties table : this.context.getTargetDatabaseProperties().getTables()) {
                    for (UniqueConstraint constraint : table.getUniqueConstraints()) {
                        String sql = dialect.getDropUniqueConstraintSQL(constraint);
                        this.logger.log(Level.DEBUG, sql, new Object[0]);
                        statement.addBatch(sql);
                    }
                }
                statement.executeBatch();
            }
            finally {
                Resources.close(statement);
            }
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreUniqueConstraints() throws SQLException {
        Dialect dialect = this.context.getDialect();
        Connection connection = this.context.getConnection(this.context.getTargetDatabase());
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            try {
                for (TableProperties table : this.context.getSourceDatabaseProperties().getTables()) {
                    for (UniqueConstraint constraint : table.getUniqueConstraints()) {
                        String sql = dialect.getCreateUniqueConstraintSQL(constraint);
                        this.logger.log(Level.DEBUG, sql, new Object[0]);
                        statement.addBatch(sql);
                    }
                }
                statement.executeBatch();
            }
            finally {
                Resources.close(statement);
            }
        }
        finally {
            connection.setAutoCommit(autoCommit);
        }
    }

    @Override
    public void rollback(Connection connection) {
        try {
            connection.rollback();
        }
        catch (SQLException e) {
            this.logger.log(Level.WARN, e);
        }
    }

    @Override
    public Object getObject(ResultSet resultSet, int index, int type) throws SQLException {
        switch (type) {
            case 2004: {
                return resultSet.getBlob(index);
            }
            case 2005: {
                return resultSet.getClob(index);
            }
        }
        return resultSet.getObject(index);
    }
}

