/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.tx;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;

public class SimpleTransactionIdentifierFactory
implements TransactionIdentifierFactory<Long> {
    private final AtomicLong counter = new AtomicLong(0L);

    @Override
    public Long createTransactionIdentifier() {
        return this.counter.incrementAndGet();
    }

    @Override
    public byte[] serialize(Long transactionId) {
        return ByteBuffer.allocate(this.size()).putLong(transactionId).array();
    }

    @Override
    public Long deserialize(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    @Override
    public int size() {
        return 64;
    }
}

