/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.tx;

import java.nio.ByteBuffer;
import java.util.UUID;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;

public class UUIDTransactionIdentifierFactory
implements TransactionIdentifierFactory<UUID> {
    @Override
    public UUID createTransactionIdentifier() {
        return UUID.randomUUID();
    }

    @Override
    public byte[] serialize(UUID transactionId) {
        return ByteBuffer.allocate(this.size()).putLong(transactionId.getMostSignificantBits()).putLong(transactionId.getLeastSignificantBits()).array();
    }

    @Override
    public UUID deserialize(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return new UUID(buffer.getLong(), buffer.getLong());
    }

    @Override
    public int size() {
        return 128;
    }
}

