/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.tx;

import java.nio.ByteBuffer;
import java.util.Random;
import javax.transaction.xa.Xid;
import net.sf.hajdbc.tx.TransactionIdentifierFactory;

public class XidTransactionIdentifierFactory
implements TransactionIdentifierFactory<Xid> {
    @Override
    public Xid createTransactionIdentifier() {
        Random random = new Random(System.currentTimeMillis());
        final int formatId = random.nextInt();
        final byte[] globalTransactionId = new byte[64];
        random.nextBytes(globalTransactionId);
        final byte[] branchQualifier = new byte[64];
        random.nextBytes(branchQualifier);
        return new Xid(){

            @Override
            public int getFormatId() {
                return formatId;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return globalTransactionId;
            }

            @Override
            public byte[] getBranchQualifier() {
                return branchQualifier;
            }
        };
    }

    @Override
    public byte[] serialize(Xid xid) {
        return ByteBuffer.allocate(this.size()).putInt(xid.getFormatId()).put(xid.getGlobalTransactionId()).put(xid.getBranchQualifier()).array();
    }

    @Override
    public Xid deserialize(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        final int formatId = buffer.getInt();
        final byte[] globalTransactionId = new byte[64];
        buffer.get(globalTransactionId);
        final byte[] branchQualifier = new byte[64];
        buffer.get(branchQualifier);
        return new Xid(){

            @Override
            public int getFormatId() {
                return formatId;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return globalTransactionId;
            }

            @Override
            public byte[] getBranchQualifier() {
                return branchQualifier;
            }
        };
    }

    @Override
    public int size() {
        return 160;
    }
}

