/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hajdbc.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    public static final SortedSet<?> EMPTY_SORTED_SET = new EmptySortedSet();
    public static final SortedMap<?, ?> EMPTY_SORTED_MAP = new EmptySortedMap();
    static final Iterator<?> EMPTY_ITERATOR = new EmptyIterator();
    static final Comparator<?> NATURAL_COMPARATOR = new NaturalComparator();

    static <E> Iterator<E> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    static <E> Comparator<E> naturalComparator() {
        return NATURAL_COMPARATOR;
    }

    public static <E> SortedSet<E> emptySortedSet() {
        return EMPTY_SORTED_SET;
    }

    public static <K, V> SortedMap<K, V> emptySortedMap() {
        return EMPTY_SORTED_MAP;
    }

    public static <E> SortedSet<E> singletonSortedSet(E element) {
        return new SingletonSortedSet<E>(element);
    }

    public static <K, V> SortedMap<K, V> singletonSortedMap(K key, V value) {
        return new SingletonSortedMap<K, V>(key, value);
    }

    private Collections() {
    }

    static class SingletonSortedMap<K, V>
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -3229163217706447957L;
        private final Map.Entry<K, V> entry;

        SingletonSortedMap(K key, V value) {
            this.entry = new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
        }

        @Override
        public boolean containsKey(Object object) {
            return this.entry.getKey().equals(object);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.entry.getValue().equals(object);
        }

        @Override
        public V get(Object object) {
            return this.entry.getKey().equals(object) ? (V)this.entry.getValue() : null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<K> keySet() {
            return java.util.Collections.singleton(this.entry.getKey());
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Collection<V> values() {
            return java.util.Collections.singleton(this.entry.getValue());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return java.util.Collections.singleton(this.entry);
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public K firstKey() {
            return this.entry.getKey();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return Collections.naturalComparator().compare(this.entry.getKey(), toKey) < 0 ? this : Collections.emptySortedMap();
        }

        @Override
        public K lastKey() {
            return this.entry.getKey();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            Comparator comparator = Collections.naturalComparator();
            return comparator.compare(this.entry.getKey(), toKey) < 0 && comparator.compare(this.entry.getKey(), fromKey) >= 0 ? this : Collections.emptySortedMap();
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return Collections.naturalComparator().compare(this.entry.getKey(), fromKey) >= 0 ? this : Collections.emptySortedMap();
        }
    }

    static class SingletonSortedSet<E>
    extends AbstractSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -7831170170325623175L;
        private final E element;

        SingletonSortedSet(E element) {
            this.element = element;
        }

        @Override
        public Iterator<E> iterator() {
            return new SingletonIterator<E>(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object object) {
            return this.element.equals(object);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Comparator<? super E> comparator() {
            return null;
        }

        @Override
        public E first() {
            return this.element;
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return Collections.naturalComparator().compare(this.element, toElement) < 0 ? this : Collections.emptySortedSet();
        }

        @Override
        public E last() {
            return this.element;
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            Comparator comparator = Collections.naturalComparator();
            return comparator.compare(this.element, toElement) < 0 && comparator.compare(this.element, fromElement) >= 0 ? this : Collections.emptySortedSet();
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return Collections.naturalComparator().compare(this.element, fromElement) >= 0 ? this : Collections.emptySortedSet();
        }
    }

    static class NullComparator<E>
    implements Comparator<E>,
    Serializable {
        private static final long serialVersionUID = -8178822438438191299L;

        NullComparator() {
        }

        @Override
        public int compare(E object1, E object2) {
            return 0;
        }
    }

    static class SingletonIterator<E>
    implements Iterator<E> {
        private final E element;
        private boolean hasNext = true;

        SingletonIterator(E element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class EmptySortedMap<K, V>
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -7955186590936566806L;

        EmptySortedMap() {
        }

        @Override
        public boolean containsKey(Object object) {
            return false;
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public V get(Object object) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Set<K> keySet() {
            return java.util.Collections.emptySet();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<V> values() {
            return java.util.Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return java.util.Collections.emptySet();
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public K firstKey() {
            throw new NoSuchElementException();
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return Collections.emptySortedMap();
        }

        @Override
        public K lastKey() {
            throw new NoSuchElementException();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return Collections.emptySortedMap();
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return Collections.emptySortedMap();
        }
    }

    static class EmptySortedSet<E>
    extends AbstractSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 8614249160102450427L;

        EmptySortedSet() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Comparator<? super E> comparator() {
            return null;
        }

        @Override
        public E first() {
            throw new NoSuchElementException();
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return Collections.emptySortedSet();
        }

        @Override
        public E last() {
            throw new NoSuchElementException();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return Collections.emptySortedSet();
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return Collections.emptySortedSet();
        }
    }

    static class EmptyIterator<E>
    implements Iterator<E> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class NaturalComparator<E>
    implements Comparator<E>,
    Serializable {
        private static final long serialVersionUID = 984839581274651936L;

        NaturalComparator() {
        }

        @Override
        public int compare(E object1, E object2) {
            return ((Comparable)object1).compareTo(object2);
        }
    }
}

